/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPanelManager;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.datacleaner.validator.ValidationRuleManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddValidationRuleButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 451961366258616382L;
    private static ConfigurationPanelManager _configurationPanelManager = GuiConfiguration.getConfigurationPanelManager();
    private ColumnSelection _columnSelection;
    private JTabbedPane _tabbedPane;
    private Map<JPanel, IConfigurationPanel> _configurationPanels;

    public AddValidationRuleButton(ColumnSelection columnSelection, JTabbedPane tabbedPane, Map<JPanel, IConfigurationPanel> panels) {
        super("Add validation rule", GuiHelper.getImageIcon("images/toolbar_add.png"));
        this._columnSelection = columnSelection;
        this._tabbedPane = tabbedPane;
        this._configurationPanels = panels;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IValidationRuleDescriptor[] validationRuleDescriptors;
        JPopupMenu popup = new JPopupMenu("Validation rules");
        for (IValidationRuleDescriptor descriptor : validationRuleDescriptors = ValidationRuleManager.getValidationRuleDescriptors()) {
            popup.add(this.createValidationRuleItem(descriptor));
        }
        popup.show(this, 0, this.getHeight());
    }

    private JMenuItem createValidationRuleItem(final IValidationRuleDescriptor descriptor) {
        final ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        final String displayName = descriptor.getDisplayName();
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IConfigurationPanel configurationPanel = _configurationPanelManager.getPanelForValidationRule(descriptor.getValidationRuleClass());
                configurationPanel.initialize(AddValidationRuleButton.this._tabbedPane, descriptor, AddValidationRuleButton.this._columnSelection, (IRunnableConfiguration)new ValidationRuleConfiguration(descriptor));
                JPanel panel = configurationPanel.getPanel();
                AddValidationRuleButton.this._configurationPanels.put(panel, configurationPanel);
                AddValidationRuleButton.this._tabbedPane.addTab(displayName, icon, new JScrollPane(panel));
            }
        });
        return item;
    }
}

