/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.thirdparty.tabs.CloseableTabbedPane;
import dk.eobjects.thirdparty.tabs.TabCloseEvent;
import dk.eobjects.thirdparty.tabs.TabCloseListener;
import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPanelTabCloseListener
implements TabCloseListener {
    private static final Log _log = LogFactory.getLog(ConfigurationPanelTabCloseListener.class);
    private CloseableTabbedPane _tabbedPane;
    private Map<JPanel, IConfigurationPanel> _configurationPanels;

    public ConfigurationPanelTabCloseListener(CloseableTabbedPane tabbedPane, Map<JPanel, IConfigurationPanel> configurationPanels) {
        this._tabbedPane = tabbedPane;
        this._configurationPanels = configurationPanels;
    }

    @Override
    public void tabClosed(TabCloseEvent event) {
        int tabIndex = event.getClosedTab();
        Component component = this._tabbedPane.getComponent(tabIndex);
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getComponent(0);
        }
        this._tabbedPane.remove(tabIndex);
        IConfigurationPanel configurationPanel = this._configurationPanels.get(component);
        if (configurationPanel == null) {
            _log.error((Object)"Could not identify a configurationPanel for closed tab");
        } else {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Destroying configuration: " + configurationPanel.getConfiguration()));
                }
                configurationPanel.destroy();
            }
            catch (Exception e) {
                _log.info((Object)("Exception thrown while destroying configuration panel: " + e.getMessage()));
                _log.debug((Object)e);
            }
            this._configurationPanels.remove(component);
        }
    }
}

