/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.widgets.ColumnHighlighter;
import dk.eobjects.datacleaner.gui.widgets.DataCleanerTable;
import dk.eobjects.datacleaner.gui.windows.DataSetWindow;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.data.DataSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.Highlighter;

public class MatrixTable
extends DataCleanerTable {
    private static final long serialVersionUID = 7057950015120409869L;
    private static final Icon HYPERLINK_ICON = GuiHelper.getImageIcon("images/matrixtable_goto_details.png");
    private final DataContext _dataContext;
    private final IMatrix _matrix;
    private boolean _horisontalMatrix;
    private TableCellRenderer _hyperlinkCellRenderer = new TableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MatrixValue mv = (MatrixValue)value;
            String text = "<null>";
            if (mv.getValue() != null) {
                text = mv.getValue().toString();
            }
            JLabel label = new JLabel(text, HYPERLINK_ICON, 4);
            label.setOpaque(true);
            label.setToolTipText("Click to drill to detail data for this measure.");
            Font font = label.getFont().deriveFont(1);
            label.setFont(font);
            return label;
        }
    };
    private TableCellRenderer _labelCellRenderer = new TableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = "<null>";
            if (value instanceof MatrixValue) {
                MatrixValue mv = (MatrixValue)value;
                if (mv.getValue() != null) {
                    text = mv.getValue().toString();
                }
            } else if (value != null) {
                text = value.toString();
            }
            JLabel label = new JLabel(text, 4);
            label.setOpaque(true);
            return label;
        }
    };
    private TableCellEditor _doNothingEditor = new TableCellEditor(){

        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return null;
        }

        public void addCellEditorListener(CellEditorListener l) {
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return null;
        }

        public void removeCellEditorListener(CellEditorListener l) {
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }
    };

    public MatrixTable(IMatrix matrix, DataContext dataContext) {
        this.setHighlighters(new Highlighter[]{GuiHelper.LIBERELLO_HIGHLIGHTER, new ColumnHighlighter(0)});
        this._dataContext = dataContext;
        this._matrix = matrix;
        this.setEditable(true);
        boolean horisontalMatrix = GuiSettings.getSettings().isHorisontalMatrixTables();
        this.updateTableModel(horisontalMatrix);
        JMenuItem diceTableMenuItem = new JMenuItem("Swap columns and rows", GuiHelper.getImageIcon("images/matrixtable_swap_dimensions.png"));
        diceTableMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixTable.this.updateTableModel(!MatrixTable.this._horisontalMatrix);
            }
        });
        this._rightClickMenuItems.add(diceTableMenuItem);
    }

    public void updateTableModel(boolean horisontalMatrix) {
        this._horisontalMatrix = horisontalMatrix;
        DefaultTableModel tableModel = new DefaultTableModel();
        String[] rowNames = this._matrix.getRowNames();
        String[] columnNames = this._matrix.getColumnNames();
        MatrixValue[][] values = this._matrix.getValues();
        if (this._horisontalMatrix) {
            int i;
            Object[] headers = new String[columnNames.length + 1];
            headers[0] = "";
            for (i = 0; i < columnNames.length; ++i) {
                headers[i + 1] = columnNames[i];
            }
            tableModel.setColumnIdentifiers(headers);
            tableModel.setRowCount(rowNames.length);
            for (i = 0; i < rowNames.length; ++i) {
                String rowName = rowNames[i];
                tableModel.setValueAt(rowName, i, 0);
            }
            for (i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    tableModel.setValueAt(values[i][j], i, 1 + j);
                }
            }
        } else {
            int i;
            Object[] headers = new String[rowNames.length + 1];
            headers[0] = "";
            for (i = 0; i < rowNames.length; ++i) {
                headers[i + 1] = rowNames[i];
            }
            tableModel.setColumnIdentifiers(headers);
            tableModel.setRowCount(columnNames.length);
            for (i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                tableModel.setValueAt(columnName, i, 0);
            }
            for (i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    tableModel.setValueAt(values[i][j], j, 1 + i);
                }
            }
        }
        this.setModel(tableModel);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        MatrixValue mv;
        if (column == 0) {
            return this._labelCellRenderer;
        }
        Object value = this.getValueAt(row, column);
        if (value instanceof MatrixValue && (mv = (MatrixValue)value).isDetailed()) {
            return this._hyperlinkCellRenderer;
        }
        return this._labelCellRenderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        MatrixValue mv;
        Object value = this.getValueAt(row, column);
        if (value instanceof MatrixValue && (mv = (MatrixValue)value).isDetailed()) {
            String rowName;
            String columnName;
            DataSet detailsData = mv.getDetails(this._dataContext);
            if (this._horisontalMatrix) {
                columnName = this._matrix.getColumnNames()[column - 1];
                rowName = this._matrix.getRowNames()[row];
            } else {
                columnName = this._matrix.getRowNames()[column - 1];
                rowName = this._matrix.getColumnNames()[row];
            }
            DataSetWindow frame = new DataSetWindow("Detail data for [" + columnName + ", " + rowName + "]", detailsData);
            DataCleanerGui.getMainWindow().addWindow(frame);
        }
        return this._doNothingEditor;
    }
}

