/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.CombinationFilter;
import dk.eobjects.datacleaner.gui.windows.ProfilerWindow;
import dk.eobjects.datacleaner.gui.windows.ValidatorWindow;
import dk.eobjects.datacleaner.util.DomHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenFileActionListener
implements ActionListener {
    private Log _log = LogFactory.getLog(OpenFileActionListener.class);

    public void actionPerformed(ActionEvent event) {
        block5: {
            JFileChooser fileChooser = new JFileChooser();
            CombinationFilter combinationFilter = new CombinationFilter(ProfilerWindow.EXTENSION_FILTER, ValidatorWindow.EXTENSION_FILTER);
            fileChooser.addChoosableFileFilter(combinationFilter);
            fileChooser.addChoosableFileFilter(ProfilerWindow.EXTENSION_FILTER);
            fileChooser.addChoosableFileFilter(ValidatorWindow.EXTENSION_FILTER);
            fileChooser.setFileFilter(combinationFilter);
            GuiHelper.centerOnScreen(fileChooser);
            if (fileChooser.showOpenDialog(null) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    DocumentBuilder documentBuilder = DomHelper.getDocumentBuilder();
                    Document document = documentBuilder.parse(file);
                    Element rootNode = document.getDocumentElement();
                    if ("profiler".equals(rootNode.getNodeName())) {
                        ProfilerWindow window = ProfilerWindow.deserialize(rootNode);
                        DataCleanerGui.getMainWindow().addWindow(window);
                        break block5;
                    }
                    if ("validator".equals(rootNode.getNodeName())) {
                        ValidatorWindow window = ValidatorWindow.deserialize(rootNode);
                        DataCleanerGui.getMainWindow().addWindow(window);
                        break block5;
                    }
                    throw new Exception("Could not deserialize node with name '" + rootNode.getNodeName() + "'");
                }
                catch (Exception e) {
                    this._log.warn((Object)e);
                    GuiHelper.showErrorMessage("Error opening file", "An error occurred when opening the file '" + file.getName() + "'", e);
                }
            }
        }
    }
}

