/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.datacleaner.execution.ProfileRunner;
import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.tasks.RunnerWrapper;
import dk.eobjects.datacleaner.gui.widgets.LogInternalFrameProgressObserver;
import dk.eobjects.datacleaner.gui.windows.ProfileResultWindow;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.metamodel.schema.Table;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunProfilerButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 6789940894608611387L;
    private DataContextSelection _dataContextSelection;
    private Map<JPanel, IConfigurationPanel> _configurationPanels;

    public RunProfilerButton(DataContextSelection dataContextSelection, Map<JPanel, IConfigurationPanel> panels) {
        super("Run profiling", GuiHelper.getImageIcon("images/toolbar_run.png"));
        this.addActionListener(this);
        this._dataContextSelection = dataContextSelection;
        this._configurationPanels = panels;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ProfileRunner profileRunner = new ProfileRunner();
        boolean foundConfiguration = false;
        for (IConfigurationPanel configurationsPanel : this._configurationPanels.values()) {
            ProfileConfiguration configuration = (ProfileConfiguration)configurationsPanel.getConfiguration();
            if (configuration.getColumns().length <= 0) continue;
            profileRunner.addConfiguration((IRunnableConfiguration)configuration);
            foundConfiguration = true;
        }
        if (foundConfiguration) {
            final ProfileResultWindow internalFrame = new ProfileResultWindow();
            DataCleanerGui.getMainWindow().addWindow(internalFrame);
            profileRunner.addProgressObserver((IProgressObserver)new LogInternalFrameProgressObserver(internalFrame));
            RunnerWrapper runnerWrapper = new RunnerWrapper(this._dataContextSelection, (IRunner)profileRunner, internalFrame){

                public void whenDone() {
                    Table[] tables = profileRunner.getResultTables();
                    for (int j = 0; j < tables.length; ++j) {
                        Table table = tables[j];
                        List results = profileRunner.getResultsForTable(table);
                        internalFrame.addResults(table, results, RunProfilerButton.this._dataContextSelection.getDataContext());
                    }
                }
            };
            runnerWrapper.execute();
        } else {
            GuiHelper.showErrorMessage("Can't run profiling", "You need to select data and add profiles to run profiling.", new IllegalStateException());
        }
    }
}

