/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.datacleaner.execution.ValidationRuleRunner;
import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.tasks.RunnerWrapper;
import dk.eobjects.datacleaner.gui.widgets.LogInternalFrameProgressObserver;
import dk.eobjects.datacleaner.gui.windows.ValidationRuleResultWindow;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.datacleaner.validator.trivial.DummyValidationRule;
import dk.eobjects.metamodel.schema.Table;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunValidatorButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = -4118642086709810954L;
    private DataContextSelection _dataContextSelection;
    private ColumnSelection _columnSelection;
    private Map<JPanel, IConfigurationPanel> _configurationPanels;

    public RunValidatorButton(DataContextSelection dataContextSelection, ColumnSelection columnSelection, Map<JPanel, IConfigurationPanel> panels) {
        super("Run validation", GuiHelper.getImageIcon("images/toolbar_run.png"));
        this._dataContextSelection = dataContextSelection;
        this._columnSelection = columnSelection;
        this._configurationPanels = panels;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ValidationRuleRunner validationRuleRunner = new ValidationRuleRunner();
        boolean foundConfiguration = false;
        for (IConfigurationPanel configurationsPanel : this._configurationPanels.values()) {
            ValidationRuleConfiguration configuration = (ValidationRuleConfiguration)configurationsPanel.getConfiguration();
            if (configuration.getColumns().length <= 0) continue;
            foundConfiguration = true;
            validationRuleRunner.addConfiguration((IRunnableConfiguration)configuration);
        }
        if (foundConfiguration) {
            ValidationRuleConfiguration dummyConfiguration = new ValidationRuleConfiguration(DummyValidationRule.DESCRIPTOR);
            dummyConfiguration.setColumns(this._columnSelection.getColumns());
            dummyConfiguration.setValidationRuleProperties(new HashMap());
            validationRuleRunner.addConfiguration((IRunnableConfiguration)dummyConfiguration);
            final ValidationRuleResultWindow internalFrame = new ValidationRuleResultWindow(this._columnSelection);
            DataCleanerGui.getMainWindow().addWindow(internalFrame);
            validationRuleRunner.addProgressObserver((IProgressObserver)new LogInternalFrameProgressObserver(internalFrame));
            RunnerWrapper runnerWrapper = new RunnerWrapper(this._dataContextSelection, (IRunner)validationRuleRunner, internalFrame){

                public void whenDone() {
                    Table[] tables = validationRuleRunner.getResultTables();
                    for (int j = 0; j < tables.length; ++j) {
                        Table table = tables[j];
                        List results = validationRuleRunner.getResultsForTable(table);
                        internalFrame.addResults(table, results);
                    }
                }
            };
            runnerWrapper.execute();
        } else {
            GuiHelper.showErrorMessage("Can't run validation", "You need to select data and add validation rules to run validation.", new IllegalStateException());
        }
    }
}

