/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.widgets;

import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Schema;
import dk.eobjects.metamodel.schema.Table;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class SchemaTree
extends JTree
implements Observer,
TreeWillExpandListener {
    private static final long serialVersionUID = 7763827443642264329L;
    public static final String LOADING_NODE_STRING = "Loading tables...";
    public static final String UNNAMED_SCHEMA_STRING = "(unnamed schema)";
    public static final String ROOT_NODE_STRING = "Schemas";
    private DataContextSelection _dataContextSelection;

    public SchemaTree(DataContextSelection dataContextSelection) {
        this._dataContextSelection = dataContextSelection;
        this._dataContextSelection.addObserver(this);
        this.addTreeWillExpandListener(this);
        this.updateTree();
    }

    private void updateTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        rootNode.setUserObject(ROOT_NODE_STRING);
        DataContext dataContext = this._dataContextSelection.getDataContext();
        if (dataContext == null) {
            rootNode.setUserObject("No data selected");
        } else {
            String[] schemaNames = dataContext.getSchemaNames();
            for (int i = 0; i < schemaNames.length; ++i) {
                String schemaName = schemaNames[i];
                if (schemaName == null) {
                    schemaName = UNNAMED_SCHEMA_STRING;
                }
                DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schemaName);
                schemaNode.add(new DefaultMutableTreeNode(LOADING_NODE_STRING));
                rootNode.add(schemaNode);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.setModel(treeModel);
    }

    public void update(Observable o, Object arg) {
        if (o instanceof DataContextSelection) {
            this.updateTree();
        }
    }

    public static Column getColumn(Table table, TreePath path) {
        if (path.getPathCount() >= 4) {
            return table.getColumnByName(path.getPathComponent(3).toString());
        }
        return null;
    }

    public static Table getTable(Schema schema, TreePath path) {
        if (path.getPathCount() >= 3) {
            return schema.getTableByName(path.getPathComponent(2).toString());
        }
        return null;
    }

    public static Schema getSchema(DataContext dc, TreePath path) {
        if (path.getPathCount() >= 2) {
            String schemaName = path.getPathComponent(1).toString();
            if (UNNAMED_SCHEMA_STRING.equals(schemaName)) {
                schemaName = null;
            }
            Schema schema = dc.getSchemaByName(schemaName);
            return schema;
        }
        return null;
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        DefaultMutableTreeNode lastComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (lastComponent.getChildCount() == 1 && ((DefaultMutableTreeNode)lastComponent.getChildAt(0)).getUserObject() == LOADING_NODE_STRING) {
            Table[] tables;
            DataContext dc = this._dataContextSelection.getDataContext();
            Schema schema = SchemaTree.getSchema(dc, path);
            for (Table table : tables = schema.getTables()) {
                Column[] columns;
                DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table.getName());
                for (Column column : columns = table.getColumns()) {
                    DefaultMutableTreeNode columnNode = new DefaultMutableTreeNode(column.getName());
                    tableNode.add(columnNode);
                }
                lastComponent.add(tableNode);
            }
            lastComponent.remove(0);
            this.setModel(this.getModel());
        }
    }
}

