/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.comparator.ColumnComparator;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.widgets.MatrixTable;
import dk.eobjects.datacleaner.gui.windows.LogResultWindow;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.metamodel.schema.Column;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class ComparisonResultWindow
extends LogResultWindow {
    public ComparisonResultWindow() {
        super("Comparison results");
    }

    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/task_result.png");
    }

    public void addResults(ColumnComparator columnComparator) {
        Column[] columns = columnComparator.getColumns();
        String title = this.getTitle(columns);
        JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
        JLabel label = new JLabel("Comparison results for columns: " + title);
        label.setFont(GuiHelper.HEADER_FONT);
        taskPaneContainer.add((Component)label);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this._tabbedPane.addTab(title, GuiHelper.getImageIcon("images/toolbar_preview_data.png"), new JScrollPane(panel));
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            JXTaskPane taskPane = new JXTaskPane();
            taskPane.setTitle("Found in " + column.getName());
            IMatrix matrix = columnComparator.getResultForColumn(column);
            MatrixTable table = new MatrixTable(matrix, null);
            taskPane.add((Component)table.toPanel());
            taskPaneContainer.add(taskPane);
        }
        panel.add((Component)taskPaneContainer, "Center");
        this._tabbedPane.setSelectedIndex(1);
    }

    private String getTitle(Column[] columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(columns[i].getName());
        }
        return sb.toString();
    }
}

