/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.catalog.NamedRegex;
import dk.eobjects.datacleaner.catalog.TextFileDictionary;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.AboutDialog;
import dk.eobjects.datacleaner.gui.dialogs.DatabaseDictionaryDialog;
import dk.eobjects.datacleaner.gui.dialogs.DatabaseDriverDialog;
import dk.eobjects.datacleaner.gui.dialogs.NamedRegexDialog;
import dk.eobjects.datacleaner.gui.dialogs.NewTaskDialog;
import dk.eobjects.datacleaner.gui.dialogs.SettingsDialog;
import dk.eobjects.datacleaner.gui.dialogs.TextFileDictionaryDialog;
import dk.eobjects.datacleaner.gui.model.DatabaseDictionary;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.widgets.OpenFileActionListener;
import dk.eobjects.datacleaner.gui.windows.AbstractWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class MainWindow
implements Observer {
    private static final String VERSION_INFO = "DataCleaner version 1.3";
    private static final long serialVersionUID = -2859158909004213811L;
    private static final Log _log = LogFactory.getLog(MainWindow.class);
    private JFrame _frame;
    private List<JFrame> _windows = new ArrayList<JFrame>();
    private JXStatusBar _statusBar;
    private JMenuBar _menubar;
    private JMenu _windowMenu;
    private JToolBar _topToolbar;
    private JPanel _contentPanel;
    private JToolBar _bottomToolbar;
    private JComboBox _dictionaryList;
    private JComboBox _regexList;
    private JButton _editRegexButton;
    private JButton _removeRegexButton;
    private JButton _removeDictionaryButton;
    private JButton _editDictionaryButton;

    public JFrame getFrame() {
        return this._frame;
    }

    public MainWindow removeAllWindows() {
        JFrame[] windows;
        for (JFrame window : windows = this._windows.toArray(new JFrame[this._windows.size()])) {
            window.dispose();
        }
        return this;
    }

    public MainWindow() {
        this._frame = new JFrame("DataCleaner");
        this._frame.setIconImage(GuiHelper.getImage("images/datacleaner_icon.png"));
        Dimension d = new Dimension(200, 480);
        this._frame.setPreferredSize(d);
        this._frame.setSize(d);
        this._frame.setResizable(false);
        this._frame.setLocation(100, 100);
        this._frame.setDefaultCloseOperation(0);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GuiHelper.confirmExit();
            }
        });
        this._frame.setLayout(new BorderLayout());
        this._frame.add(this.getBanner(), "North");
        ActionListener newTaskListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewTaskDialog dialog = new NewTaskDialog();
                dialog.setVisible(true);
            }
        };
        this._menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem newTaskItem = new JMenuItem("New task", GuiHelper.getImageIcon("images/toolbar_new_window.png"));
        newTaskItem.addActionListener(newTaskListener);
        newTaskItem.setMnemonic('N');
        fileMenu.add(newTaskItem);
        JMenuItem openFileItem = new JMenuItem("Open file", GuiHelper.getImageIcon("images/toolbar_open.png"));
        openFileItem.setMnemonic('O');
        openFileItem.addActionListener(new OpenFileActionListener());
        fileMenu.add(openFileItem);
        fileMenu.add(new JSeparator(0));
        JMenuItem loadRegexesItem = new JMenuItem("Load regexes from properties file", GuiHelper.getImageIcon("images/regexes.png"));
        loadRegexesItem.setMnemonic('r');
        loadRegexesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                ExtensionFilter filter = new ExtensionFilter("Property file (.properties)", "properties");
                fileChooser.setFileFilter(filter);
                GuiHelper.centerOnScreen(fileChooser);
                if (fileChooser.showOpenDialog(null) == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    try {
                        List regexes = NamedRegex.loadFromFile((File)selectedFile);
                        GuiSettings settings = GuiSettings.getSettings();
                        settings.getRegexes().addAll(regexes);
                        GuiSettings.saveSettings(settings);
                    }
                    catch (IllegalArgumentException e) {
                        GuiHelper.showErrorMessage("Could not load regexes", "Error occurred during load of regexes from file: " + selectedFile.getAbsolutePath(), e);
                    }
                }
            }
        });
        fileMenu.add(loadRegexesItem);
        JMenuItem databaseDriverItem = new JMenuItem("Register database driver", GuiHelper.getImageIcon("images/toolbar_database.png"));
        databaseDriverItem.setMnemonic('d');
        databaseDriverItem.addActionListener(DatabaseDriverDialog.getActionListener());
        fileMenu.add(databaseDriverItem);
        fileMenu.add(new JSeparator(0));
        JMenuItem exitItem = new JMenuItem("Exit DataCleaner", GuiHelper.getImageIcon("images/menu_exit.png"));
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiHelper.confirmExit();
            }
        });
        fileMenu.add(exitItem);
        this._menubar.add(fileMenu);
        ActionListener settingsActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog dialog = new SettingsDialog();
                dialog.setVisible(true);
            }
        };
        this._menubar.add(this.createWindowMenu(settingsActionListener));
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        OpenBrowserAction action = null;
        try {
            action = new OpenBrowserAction("http://www.eobjects.dk/trac/wiki/DataCleanerUserGuide");
        }
        catch (MalformedURLException e) {
            _log.error((Object)e);
        }
        JMenuItem helpContentItem = new JMenuItem((Action)action);
        helpContentItem.setMnemonic('H');
        helpContentItem.setText("Help contents");
        helpContentItem.setIcon(GuiHelper.getImageIcon("images/menu_help.png"));
        helpMenu.add(helpContentItem);
        JMenuItem aboutItem = new JMenuItem("About DataCleaner", GuiHelper.getImageIcon("images/menu_about.png"));
        aboutItem.setMnemonic('A');
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog dialog = new AboutDialog();
                dialog.setVisible(true);
            }
        });
        helpMenu.add(aboutItem);
        this._menubar.add(helpMenu);
        this._frame.setJMenuBar(this._menubar);
        this._topToolbar = new JToolBar(0);
        this._topToolbar.setRollover(true);
        this._topToolbar.setFloatable(false);
        this._topToolbar.setBackground(HighlighterFactory.BEIGE);
        JButton newTaskButton = new JButton("New task", GuiHelper.getImageIcon("images/toolbar_new_window.png"));
        newTaskButton.addActionListener(newTaskListener);
        this._topToolbar.add(newTaskButton);
        JButton settingsButton = new JButton("Settings", GuiHelper.getImageIcon("images/toolbar_settings.png"));
        settingsButton.addActionListener(settingsActionListener);
        this._topToolbar.add(settingsButton);
        this._statusBar = new JXStatusBar();
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        this._statusBar.add((Component)new JLabel(VERSION_INFO), (Object)c1);
        this._contentPanel = new JPanel(new BorderLayout());
        this._contentPanel.add((Component)this._topToolbar, "North");
        JPanel panel = new JPanel(new FlowLayout(0, 4, 20));
        GuiSettings settings = GuiSettings.getSettings();
        panel.add(this.getDictionaryPanel(settings));
        panel.add(this.getRegexPanel(settings));
        this._contentPanel.add((Component)panel, "Center");
        this._bottomToolbar = new JToolBar(0);
        this._bottomToolbar.setRollover(true);
        this._bottomToolbar.setFloatable(false);
        this._bottomToolbar.setBackground(HighlighterFactory.BEIGE);
        action = null;
        try {
            action = new OpenBrowserAction("http://www.eobjects.dk/datacleaner");
        }
        catch (MalformedURLException e) {
            _log.error((Object)e);
        }
        JButton websiteButton = new JButton((Action)action);
        websiteButton.setText("Visit DataCleaner website");
        websiteButton.setIcon(GuiHelper.getImageIcon("images/toolbar_visit_website.png"));
        this._bottomToolbar.add(websiteButton);
        this._contentPanel.add((Component)this._bottomToolbar, "South");
        this._frame.add((Component)this._contentPanel, "Center");
        this._frame.add((Component)this._statusBar, "South");
        settings.addObserver(this);
        this._frame.pack();
        this._frame.setVisible(true);
    }

    private JPanel getDictionaryPanel(GuiSettings settings) {
        JPanel panel = new JPanel();
        panel.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY), new EmptyBorder(2, 2, 2, 2)));
        panel.setBackground(HighlighterFactory.BEIGE);
        GuiHelper.addToGridBag(new JLabel("Dictionary catalog", GuiHelper.getImageIcon("images/dictionaries.png"), 2), panel, 0, 0, 2, 1);
        this._dictionaryList = new JComboBox(new DefaultComboBoxModel());
        this._dictionaryList.setEditable(false);
        Dimension d = new Dimension(105, 16);
        this._dictionaryList.setPreferredSize(d);
        this._dictionaryList.setSize(d);
        GuiHelper.addToGridBag(this._dictionaryList, panel, 0, 1);
        JToolBar buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.setBorderPainted(false);
        buttonBar.setRollover(true);
        buttonBar.setBackground(HighlighterFactory.BEIGE);
        this._editDictionaryButton = new JButton(GuiHelper.getImageIcon("images/toolbar_open.png"));
        this._editDictionaryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IDictionary dictionary = GuiSettings.getSettings().getDictionaries().get(MainWindow.this._dictionaryList.getSelectedIndex());
                if (dictionary instanceof TextFileDictionary) {
                    TextFileDictionaryDialog dialog = new TextFileDictionaryDialog((TextFileDictionary)dictionary);
                    dialog.setVisible(true);
                } else if (dictionary instanceof DatabaseDictionary) {
                    DatabaseDictionaryDialog dialog = new DatabaseDictionaryDialog((DatabaseDictionary)dictionary);
                    dialog.setVisible(true);
                }
            }
        });
        buttonBar.add(this._editDictionaryButton);
        this._removeDictionaryButton = new JButton(GuiHelper.getImageIcon("images/toolbar_remove.png"));
        this._removeDictionaryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int choise = JOptionPane.showConfirmDialog(MainWindow.this._frame, "Are you sure you want to remove this dictionary?", "Remove dictionary", 0);
                if (choise == 0) {
                    GuiSettings settings = GuiSettings.getSettings();
                    settings.getDictionaries().remove(MainWindow.this._dictionaryList.getSelectedIndex());
                    GuiSettings.saveSettings(settings);
                }
            }
        });
        buttonBar.add(this._removeDictionaryButton);
        GuiHelper.addToGridBag(buttonBar, panel, 1, 1);
        buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.setBorderPainted(false);
        buttonBar.setRollover(true);
        buttonBar.setBackground(HighlighterFactory.BEIGE);
        final JButton addButton = new JButton("New dictionary", GuiHelper.getImageIcon("images/toolbar_add.png"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu popupMenu = new JPopupMenu("Add dictionary");
                JMenuItem textfileItem = new JMenuItem("Text-file dictionary", GuiHelper.getImageIcon("images/toolbar_file.png"));
                textfileItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TextFileDictionaryDialog dialog = new TextFileDictionaryDialog(null);
                        dialog.setVisible(true);
                    }
                });
                popupMenu.add(textfileItem);
                JMenuItem databaseItem = new JMenuItem("Database dictionary", GuiHelper.getImageIcon("images/toolbar_database.png"));
                databaseItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DatabaseDictionaryDialog dialog = new DatabaseDictionaryDialog(null);
                        dialog.setVisible(true);
                    }
                });
                popupMenu.add(databaseItem);
                popupMenu.show(addButton, addButton.getWidth(), 0);
            }
        });
        buttonBar.add(addButton);
        GuiHelper.addToGridBag(buttonBar, panel, 0, 2, 2, 1);
        this.updateDictionaryList(settings);
        return panel;
    }

    private void updateDictionaryList(GuiSettings settings) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._dictionaryList.getModel();
        model.removeAllElements();
        List<IDictionary> dictionaries = settings.getDictionaries();
        for (IDictionary dictionary : dictionaries) {
            model.addElement(dictionary.getName());
        }
        if (dictionaries.size() == 0) {
            this._editDictionaryButton.setEnabled(false);
            this._removeDictionaryButton.setEnabled(false);
        } else {
            this._editDictionaryButton.setEnabled(true);
            this._removeDictionaryButton.setEnabled(true);
        }
    }

    private JPanel getRegexPanel(GuiSettings settings) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY), new EmptyBorder(2, 2, 2, 2)));
        panel.setBackground(HighlighterFactory.BEIGE);
        GuiHelper.addToGridBag(new JLabel("Regex catalog", GuiHelper.getImageIcon("images/regexes.png"), 2), panel, 0, 0, 2, 1);
        this._regexList = new JComboBox(new DefaultComboBoxModel());
        this._regexList.setEditable(false);
        Dimension d = new Dimension(105, 16);
        this._regexList.setPreferredSize(d);
        this._regexList.setSize(d);
        GuiHelper.addToGridBag(this._regexList, panel, 0, 1);
        JToolBar buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.setBorderPainted(false);
        buttonBar.setRollover(true);
        buttonBar.setBackground(HighlighterFactory.BEIGE);
        this._editRegexButton = new JButton(GuiHelper.getImageIcon("images/toolbar_open.png"));
        this._editRegexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamedRegex regex = GuiSettings.getSettings().getRegexes().get(MainWindow.this._regexList.getSelectedIndex());
                NamedRegexDialog dialog = new NamedRegexDialog(regex);
                dialog.setVisible(true);
            }
        });
        buttonBar.add(this._editRegexButton);
        this._removeRegexButton = new JButton(GuiHelper.getImageIcon("images/toolbar_remove.png"));
        this._removeRegexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int choise = JOptionPane.showConfirmDialog(MainWindow.this._frame, "Are you sure you want to remove this regex?", "Remove regex", 0);
                if (choise == 0) {
                    GuiSettings settings = GuiSettings.getSettings();
                    settings.getRegexes().remove(MainWindow.this._regexList.getSelectedIndex());
                    GuiSettings.saveSettings(settings);
                }
            }
        });
        buttonBar.add(this._removeRegexButton);
        GuiHelper.addToGridBag(buttonBar, panel, 1, 1);
        buttonBar = new JToolBar();
        buttonBar.setFloatable(false);
        buttonBar.setBorderPainted(false);
        buttonBar.setRollover(true);
        buttonBar.setBackground(HighlighterFactory.BEIGE);
        JButton addButton = new JButton("New regex", GuiHelper.getImageIcon("images/toolbar_add.png"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamedRegexDialog dialog = new NamedRegexDialog(null);
                dialog.setVisible(true);
            }
        });
        buttonBar.add(addButton);
        GuiHelper.addToGridBag(buttonBar, panel, 0, 2, 2, 1);
        this.updateRegexList(settings);
        return panel;
    }

    private void updateRegexList(GuiSettings settings) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._regexList.getModel();
        model.removeAllElements();
        List<NamedRegex> regexes = settings.getRegexes();
        for (NamedRegex regex : regexes) {
            model.addElement(regex.getName());
        }
        if (regexes.size() == 0) {
            this._editRegexButton.setEnabled(false);
            this._removeRegexButton.setEnabled(false);
        } else {
            this._editRegexButton.setEnabled(true);
            this._removeRegexButton.setEnabled(true);
        }
    }

    private JMenu createWindowMenu(ActionListener settingsActionListener) {
        this._windowMenu = new JMenu("Window");
        this._windowMenu.setMnemonic('W');
        JMenuItem settingsItem = new JMenuItem("Settings", GuiHelper.getImageIcon("images/toolbar_settings.png"));
        settingsItem.setMnemonic('S');
        settingsItem.addActionListener(settingsActionListener);
        this._windowMenu.add(settingsItem);
        JMenuItem cascadeItem = new JMenuItem("Cascade", GuiHelper.getImageIcon("images/menu_cascade.png"));
        cascadeItem.setMnemonic('C');
        cascadeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.cascade();
            }
        });
        this._windowMenu.add(cascadeItem);
        this._windowMenu.add(new JSeparator());
        return this._windowMenu;
    }

    public MainWindow addWindow(AbstractWindow window) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding frame: " + window));
        }
        final JFrame frame = window.toFrame();
        frame.setVisible(true);
        this._windows.add(frame);
        final JMenuItem menuItem = new JMenuItem(new AbstractAction(){
            private static final long serialVersionUID = -4532336729625378602L;

            public void actionPerformed(ActionEvent e) {
                frame.toFront();
            }
        });
        menuItem.setText(window.getTitle());
        menuItem.setIcon(window.getFrameIcon());
        this._windowMenu.add(menuItem);
        frame.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                MainWindow.this._windows.remove(frame);
                MainWindow.this._windowMenu.remove(menuItem);
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        return this;
    }

    public void dispose() {
        this.removeAllWindows();
        this._frame.setVisible(false);
        this._frame.dispose();
    }

    private void cascade() {
        int x = this._frame.getLocation().x + this._frame.getWidth();
        int y = this._frame.getLocation().y;
        for (int i = 0; i < this._windows.size(); ++i) {
            JFrame window = this._windows.get(i);
            window.setLocation(x += 10, y);
            y += 30;
            if (i != this._windows.size() - 1) continue;
            window.toFront();
        }
    }

    private Component getBanner() {
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.setBorder(new MatteBorder(0, 0, 1, 0, Color.BLACK));
        ImageIcon logo = GuiHelper.getImageIcon("images/main_banner.png");
        JLabel label = new JLabel(logo);
        panel.add(label, 0, 0);
        return panel;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof GuiSettings) {
            GuiSettings settings = (GuiSettings)o;
            this.updateDictionaryList(settings);
            this.updateRegexList(settings);
        }
    }

    public void repaintAll() {
        SwingUtilities.updateComponentTreeUI(this._frame);
        List<JFrame> windows = this._windows;
        for (JFrame frame : windows) {
            SwingUtilities.updateComponentTreeUI(frame);
        }
    }
}

