/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import dk.eobjects.datacleaner.gui.panels.ColumnSelectionPanel;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPanelManager;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.MetadataPanel;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.widgets.AddProfileButton;
import dk.eobjects.datacleaner.gui.widgets.ConfigurationPanelTabCloseListener;
import dk.eobjects.datacleaner.gui.widgets.OpenDatabaseButton;
import dk.eobjects.datacleaner.gui.widgets.OpenFileButton;
import dk.eobjects.datacleaner.gui.widgets.RunProfilerButton;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.gui.widgets.SchemaTreeMouseListener;
import dk.eobjects.datacleaner.gui.windows.AbstractWindow;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.datacleaner.util.DomHelper;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.thirdparty.tabs.CloseableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProfilerWindow
extends AbstractWindow {
    public static final String NODE_NAME = "profiler";
    public static final ExtensionFilter EXTENSION_FILTER = new ExtensionFilter("DataCleaner profiler configuration (.dcp)", "dcp");
    private final DataContextSelection _dataContextSelection;
    private final ColumnSelection _columnSelection;
    private CloseableTabbedPane _tabbedPane;
    private Map<JPanel, IConfigurationPanel> _configurationPanels = new HashMap<JPanel, IConfigurationPanel>();

    public ProfilerWindow() {
        this(new DataContextSelection());
    }

    public ProfilerWindow(DataContextSelection dataContextSelection) {
        this._dataContextSelection = dataContextSelection;
        this._columnSelection = new ColumnSelection(this._dataContextSelection);
        this._tabbedPane = new CloseableTabbedPane();
        this._tabbedPane.addTabCloseListener(new ConfigurationPanelTabCloseListener(this._tabbedPane, this._configurationPanels));
        this._panel.setLayout(new BorderLayout());
        JButton saveProfilerButton = new JButton("Save", GuiHelper.getImageIcon("images/toolbar_save.png"));
        saveProfilerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProfilerWindow.this._dataContextSelection.getDataContext() == null) {
                    GuiHelper.showErrorMessage("Nothing to save", "You haven't opened a datastore yet, so there's nothing to save.", null);
                } else {
                    JFileChooser f = new JFileChooser();
                    f.setSelectedFile(new File("my_profiler.dcp"));
                    f.addChoosableFileFilter(EXTENSION_FILTER);
                    if (f.showSaveDialog(ProfilerWindow.this._panel) == 0) {
                        File file = f.getSelectedFile();
                        boolean saveFile = true;
                        if (file.exists() && JOptionPane.showConfirmDialog(ProfilerWindow.this._panel, "A file with the filename '" + file.getName() + "' already exists. Overwrite?", "Overwrite?", 0) != 0) {
                            saveFile = false;
                        }
                        if (saveFile) {
                            DocumentBuilder documentBuilder = DomHelper.getDocumentBuilder();
                            Document document = documentBuilder.newDocument();
                            DomHelper.transform((Node)ProfilerWindow.this.serialize(document), (Result)new StreamResult(file));
                        }
                    }
                }
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(new OpenDatabaseButton(this._dataContextSelection));
        toolbar.add(new OpenFileButton(this._dataContextSelection));
        toolbar.add(new JSeparator(1));
        toolbar.add(saveProfilerButton);
        toolbar.add(new AddProfileButton(this._columnSelection, this._tabbedPane, this._configurationPanels));
        toolbar.add(new RunProfilerButton(this._dataContextSelection, this._configurationPanels));
        this._panel.add((Component)toolbar, "North");
        JSplitPane splitPane = new JSplitPane(1);
        SchemaTree schemaTree = new SchemaTree(this._dataContextSelection);
        schemaTree.addMouseListener(new SchemaTreeMouseListener(schemaTree, this._dataContextSelection, this._columnSelection));
        JScrollPane scrollSchemaTree = new JScrollPane(schemaTree);
        splitPane.add(scrollSchemaTree);
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(this._dataContextSelection, this._columnSelection);
        MetadataPanel metadataPanel = new MetadataPanel(this._columnSelection);
        this._tabbedPane.addTab("Data selection", GuiHelper.getImageIcon("images/tab_data_selection.png"), columnSelectionPanel);
        this._tabbedPane.addTab("Metadata", GuiHelper.getImageIcon("images/tab_metadata.png"), new JScrollPane(metadataPanel));
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.setUnclosableTab(1);
        splitPane.add(this._tabbedPane);
        this._panel.add((Component)splitPane, "Center");
    }

    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/window_profile.png");
    }

    public String getTitle() {
        return "Profiler";
    }

    public Node serialize(Document document) {
        Element profilerNode = document.createElement(NODE_NAME);
        profilerNode.appendChild(this._dataContextSelection.serialize(document));
        for (IConfigurationPanel configurationPanel : this._configurationPanels.values()) {
            ProfileConfiguration configuration = (ProfileConfiguration)configurationPanel.getConfiguration();
            profilerNode.appendChild(configuration.serialize(document));
        }
        return profilerNode;
    }

    public static ProfilerWindow deserialize(Node node) throws SQLException {
        Node dataContextSelectionNode = (Node)DomHelper.getChildNodesByName((Node)node, (String)"dataContext").get(0);
        DataContextSelection dataContextSelection = DataContextSelection.deserialize(dataContextSelectionNode);
        ProfilerWindow window = new ProfilerWindow(dataContextSelection);
        DataContext dc = dataContextSelection.getDataContext();
        List configurationNodes = DomHelper.getChildNodesByName((Node)node, (String)"configuration");
        HashSet<Column> columns = new HashSet<Column>();
        ArrayList<ProfileConfiguration> configurations = new ArrayList<ProfileConfiguration>();
        for (Node configurationNode : configurationNodes) {
            ProfileConfiguration configuration = ProfileConfiguration.deserialize((Node)configurationNode, (DataContext)dc);
            columns.addAll(Arrays.asList(configuration.getColumns()));
            configurations.add(configuration);
        }
        for (Column column : columns) {
            window._columnSelection.toggleColumn(column);
        }
        ConfigurationPanelManager configurationPanelManager = GuiConfiguration.getConfigurationPanelManager();
        for (ProfileConfiguration configuration : configurations) {
            window.addTab(configuration, configurationPanelManager);
        }
        return window;
    }

    private void addTab(ProfileConfiguration configuration, ConfigurationPanelManager configurationPanelManager) {
        IProfileDescriptor descriptor = configuration.getProfileDescriptor();
        IConfigurationPanel configurationPanel = configurationPanelManager.getPanelForProfile(descriptor.getProfileClass());
        configurationPanel.initialize(this._tabbedPane, descriptor, this._columnSelection, (IRunnableConfiguration)configuration);
        JPanel panel = configurationPanel.getPanel();
        this._configurationPanels.put(panel, configurationPanel);
        ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        this._tabbedPane.addTab(descriptor.getDisplayName(), icon, new JScrollPane(panel));
    }
}

