/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.panels.TableValidationRuleResultsPanel;
import dk.eobjects.datacleaner.gui.windows.LogResultWindow;
import dk.eobjects.datacleaner.validator.IValidationRuleResult;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleResultWindow
extends LogResultWindow {
    private ColumnSelection _dataSelection;

    public ValidationRuleResultWindow(ColumnSelection dataSelection) {
        super("Validation results");
        this._dataSelection = dataSelection;
    }

    @Override
    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/task_result.png");
    }

    public void addResults(Table table, List<IValidationRuleResult> results) {
        for (IValidationRuleResult result : results) {
            Exception error = result.getError();
            if (error == null) continue;
            StringWriter stringWriter = new StringWriter();
            error.printStackTrace(new PrintWriter(stringWriter));
            this.addLogMessage(stringWriter.toString());
        }
        String tableName = table.getName();
        this.addLogMessage("Validation rule results for table '" + tableName + "' ready: " + new Date().toString());
        Column[] queriedColumns = MetaModelHelper.getTableColumns((Table)table, this._dataSelection.getColumns());
        TableValidationRuleResultsPanel tableProfileResultsPanel = new TableValidationRuleResultsPanel(table, queriedColumns, results);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(tableProfileResultsPanel);
        this._tabbedPane.addTab(tableName, GuiHelper.getImageIcon("images/toolbar_preview_data.png"), scrollPane);
        this._tabbedPane.setSelectedIndex(1);
    }
}

