/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.windows;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.model.ColumnSelection;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import dk.eobjects.datacleaner.gui.panels.ColumnSelectionPanel;
import dk.eobjects.datacleaner.gui.panels.ConfigurationPanelManager;
import dk.eobjects.datacleaner.gui.panels.IConfigurationPanel;
import dk.eobjects.datacleaner.gui.panels.MetadataPanel;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.widgets.AddValidationRuleButton;
import dk.eobjects.datacleaner.gui.widgets.ConfigurationPanelTabCloseListener;
import dk.eobjects.datacleaner.gui.widgets.OpenDatabaseButton;
import dk.eobjects.datacleaner.gui.widgets.OpenFileButton;
import dk.eobjects.datacleaner.gui.widgets.RunValidatorButton;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.gui.widgets.SchemaTreeMouseListener;
import dk.eobjects.datacleaner.gui.windows.AbstractWindow;
import dk.eobjects.datacleaner.util.DomHelper;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.thirdparty.tabs.CloseableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidatorWindow
extends AbstractWindow {
    public static final String NODE_NAME = "validator";
    public static final ExtensionFilter EXTENSION_FILTER = new ExtensionFilter("DataCleaner validator configuration (.dcv)", "dcv");
    private final DataContextSelection _dataContextSelection;
    private final ColumnSelection _columnSelection;
    private Map<JPanel, IConfigurationPanel> _configurationPanels = new HashMap<JPanel, IConfigurationPanel>();
    private CloseableTabbedPane _tabbedPane;

    public ValidatorWindow() {
        this(new DataContextSelection());
    }

    public ValidatorWindow(DataContextSelection dataContextSelection) {
        this._dataContextSelection = dataContextSelection;
        this._columnSelection = new ColumnSelection(this._dataContextSelection);
        this._tabbedPane = new CloseableTabbedPane();
        this._tabbedPane.addTabCloseListener(new ConfigurationPanelTabCloseListener(this._tabbedPane, this._configurationPanels));
        this._panel.setLayout(new BorderLayout());
        JButton saveValidatorButton = new JButton("Save", GuiHelper.getImageIcon("images/toolbar_save.png"));
        saveValidatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ValidatorWindow.this._dataContextSelection.getDataContext() == null) {
                    GuiHelper.showErrorMessage("Nothing to save", "You haven't opened a datastore yet, so there's nothing to save.", null);
                } else {
                    JFileChooser f = new JFileChooser();
                    f.setSelectedFile(new File("my_validator.dcv"));
                    f.addChoosableFileFilter(EXTENSION_FILTER);
                    if (f.showSaveDialog(ValidatorWindow.this._panel) == 0) {
                        File file = f.getSelectedFile();
                        boolean saveFile = true;
                        if (file.exists() && JOptionPane.showConfirmDialog(ValidatorWindow.this._panel, "A file with the filename '" + file.getName() + "' already exists. Overwrite?", "Overwrite?", 0) != 0) {
                            saveFile = false;
                        }
                        if (saveFile) {
                            DocumentBuilder documentBuilder = DomHelper.getDocumentBuilder();
                            Document document = documentBuilder.newDocument();
                            DomHelper.transform((Node)ValidatorWindow.this.serialize(document), (Result)new StreamResult(file));
                        }
                    }
                }
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(new OpenDatabaseButton(this._dataContextSelection));
        toolbar.add(new OpenFileButton(this._dataContextSelection));
        toolbar.add(new JSeparator(1));
        toolbar.add(saveValidatorButton);
        toolbar.add(new AddValidationRuleButton(this._columnSelection, this._tabbedPane, this._configurationPanels));
        toolbar.add(new RunValidatorButton(this._dataContextSelection, this._columnSelection, this._configurationPanels));
        this._panel.add((Component)toolbar, "North");
        JSplitPane splitPane = new JSplitPane(1);
        SchemaTree schemaTree = new SchemaTree(this._dataContextSelection);
        schemaTree.addMouseListener(new SchemaTreeMouseListener(schemaTree, this._dataContextSelection, this._columnSelection));
        splitPane.add(new JScrollPane(schemaTree));
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(this._dataContextSelection, this._columnSelection);
        MetadataPanel metadataPanel = new MetadataPanel(this._columnSelection);
        this._tabbedPane.addTab("Data selection", GuiHelper.getImageIcon("images/tab_data_selection.png"), columnSelectionPanel);
        this._tabbedPane.addTab("Metadata", GuiHelper.getImageIcon("images/tab_metadata.png"), metadataPanel);
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.setUnclosableTab(1);
        splitPane.add(this._tabbedPane);
        this._panel.add((Component)splitPane, "Center");
    }

    public ImageIcon getFrameIcon() {
        return GuiHelper.getImageIcon("images/window_validate.png");
    }

    public String getTitle() {
        return "Validator";
    }

    public Node serialize(Document document) {
        Element validatorNode = document.createElement(NODE_NAME);
        validatorNode.appendChild(this._dataContextSelection.serialize(document));
        for (IConfigurationPanel configurationPanel : this._configurationPanels.values()) {
            ValidationRuleConfiguration configuration = (ValidationRuleConfiguration)configurationPanel.getConfiguration();
            validatorNode.appendChild(configuration.serialize(document));
        }
        return validatorNode;
    }

    public static ValidatorWindow deserialize(Node node) throws SQLException {
        Node dataContextSelectionNode = (Node)DomHelper.getChildNodesByName((Node)node, (String)"dataContext").get(0);
        DataContextSelection dataContextSelection = DataContextSelection.deserialize(dataContextSelectionNode);
        ValidatorWindow window = new ValidatorWindow(dataContextSelection);
        DataContext dc = dataContextSelection.getDataContext();
        List configurationNodes = DomHelper.getChildNodesByName((Node)node, (String)"configuration");
        HashSet<Column> columns = new HashSet<Column>();
        ArrayList<ValidationRuleConfiguration> configurations = new ArrayList<ValidationRuleConfiguration>();
        for (Node configurationNode : configurationNodes) {
            ValidationRuleConfiguration configuration = ValidationRuleConfiguration.deserialize((Node)configurationNode, (DataContext)dc);
            columns.addAll(Arrays.asList(configuration.getColumns()));
            configurations.add(configuration);
        }
        for (Column column : columns) {
            window._columnSelection.toggleColumn(column);
        }
        ConfigurationPanelManager configurationPanelManager = GuiConfiguration.getConfigurationPanelManager();
        for (ValidationRuleConfiguration configuration : configurations) {
            window.addTab(configuration, configurationPanelManager);
        }
        return window;
    }

    private void addTab(ValidationRuleConfiguration configuration, ConfigurationPanelManager configurationPanelManager) {
        IValidationRuleDescriptor descriptor = configuration.getValidationRuleDescriptor();
        String tabTitle = (String)configuration.getValidationRuleProperties().get("Validation rule name");
        if (tabTitle == null) {
            tabTitle = descriptor.getDisplayName();
        }
        IConfigurationPanel configurationPanel = configurationPanelManager.getPanelForValidationRule(descriptor.getValidationRuleClass());
        configurationPanel.initialize(this._tabbedPane, descriptor, this._columnSelection, (IRunnableConfiguration)configuration);
        JPanel panel = configurationPanel.getPanel();
        this._configurationPanels.put(panel, configurationPanel);
        ImageIcon icon = GuiHelper.getImageIcon(descriptor.getIconPath());
        this._tabbedPane.addTab(tabTitle, icon, new JScrollPane(panel));
    }
}

