/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.thirdparty.textarea.tokermarkers;

import dk.eobjects.thirdparty.textarea.KeywordMap;
import dk.eobjects.thirdparty.textarea.SyntaxUtilities;
import dk.eobjects.thirdparty.textarea.tokermarkers.JavaScriptTokenMarker;
import dk.eobjects.thirdparty.textarea.tokermarkers.TokenMarker;
import javax.swing.text.Segment;

public class HTMLTokenMarker
extends TokenMarker {
    public static final byte JAVASCRIPT = 100;
    private KeywordMap keywords;
    private boolean js;
    private int lastOffset;
    private int lastKeyword;

    public HTMLTokenMarker() {
        this(true);
    }

    public HTMLTokenMarker(boolean js) {
        this.js = js;
        this.keywords = JavaScriptTokenMarker.getKeywords();
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block25: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    backslash = false;
                    switch (c) {
                        case '<': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            if (SyntaxUtilities.regionMatches(false, line, i1, "!--")) {
                                i += 3;
                                token = 1;
                                break;
                            }
                            if (this.js && SyntaxUtilities.regionMatches(true, line, i1, "script>")) {
                                this.addToken(8, (byte)6);
                                this.lastOffset = this.lastKeyword = (i += 8);
                                token = (byte)100;
                                break;
                            }
                            token = (byte)6;
                            break;
                        }
                        case '&': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)7;
                        }
                    }
                    continue block25;
                }
                case 6: {
                    backslash = false;
                    if (c != '>') continue block25;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block25;
                }
                case 7: {
                    backslash = false;
                    if (c != ';') continue block25;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block25;
                }
                case 1: {
                    backslash = false;
                    if (!SyntaxUtilities.regionMatches(false, line, i, "-->")) continue block25;
                    this.addToken(i + 3 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i + 3;
                    token = 0;
                    continue block25;
                }
                case 100: {
                    switch (c) {
                        case '<': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (!SyntaxUtilities.regionMatches(true, line, i1, "/script>")) continue block25;
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.addToken(9, (byte)6);
                            this.lastOffset = this.lastKeyword = (i += 9);
                            token = 0;
                            break;
                        }
                        case '\"': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)3;
                            break;
                        }
                        case '\'': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)4;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block25;
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            if (array[i1] == '/') {
                                this.addToken(length - i, (byte)2);
                                this.lastOffset = this.lastKeyword = length;
                                break block25;
                            }
                            if (array[i1] != '*') continue block25;
                            token = (byte)2;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block25;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block25;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block25;
                    }
                    if (c != '\"') continue block25;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block25;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block25;
                    }
                    if (c != '\'') continue block25;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block25;
                }
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block25;
                    this.addToken((i += 2) - this.lastOffset, (byte)2);
                    this.lastOffset = this.lastKeyword = i;
                    token = (byte)100;
                    continue block25;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = (byte)100;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 100: {
                this.doKeyword(line, length, '\u0000');
                this.addToken(length - this.lastOffset, (byte)0);
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

