/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.algorithms;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.elements.Fraction;
import dk.jonaslindstrom.ruffini.common.functional.TriFunction;
import dk.jonaslindstrom.ruffini.common.vector.Vector;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.ShortWeierstrassCurveAffine;
import dk.jonaslindstrom.ruffini.polynomials.elements.MultivariatePolynomial;
import dk.jonaslindstrom.ruffini.polynomials.structures.MultivariatePolynomialRing;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MillersAlgorithm<E>
implements TriFunction<AffinePoint<E>, AffinePoint<E>, BigInteger, E> {
    private final ShortWeierstrassCurveAffine<E, ?> curve;
    private final Field<E> field;
    private final MultivariatePolynomialRing<E> polynomialRing;

    public MillersAlgorithm(ShortWeierstrassCurveAffine<E, ?> curve) {
        this.curve = curve;
        this.field = curve.getField();
        this.polynomialRing = new MultivariatePolynomialRing(this.field, 2);
    }

    private static List<Boolean> toBits(BigInteger m) {
        return IntStream.range(0, m.bitLength()).mapToObj(m::testBit).collect(Collectors.toList());
    }

    public E apply(AffinePoint<E> P, AffinePoint<E> Q, BigInteger m) {
        List<Boolean> mBits = MillersAlgorithm.toBits(m);
        AffinePoint<E> T = P;
        Object f = this.field.getIdentity();
        for (int i = mBits.size() - 2; i >= 0; --i) {
            f = this.field.multiply(f, f, this.evaluate(this.g(T, T), Q));
            T = this.curve.add(T, T);
            if (!mBits.get(i).booleanValue()) continue;
            f = this.field.multiply(f, this.evaluate(this.g(T, P), Q));
            T = this.curve.add(T, P);
        }
        return (E)f;
    }

    private Fraction<MultivariatePolynomial<E>> g(AffinePoint<E> p, AffinePoint<E> q) {
        Object \u03bb;
        if (this.field.equals(p.x(), q.x()) && !this.curve.equals(p, q)) {
            MultivariatePolynomial.Builder builder = new MultivariatePolynomial.Builder(2, this.field);
            builder.add(this.field.getIdentity(), new int[]{1, 0});
            builder.add(this.field.negate(p.x()), new int[]{0, 0});
            return new Fraction((Object)builder.build(), (Object)this.polynomialRing.getIdentity());
        }
        if (this.curve.equals(p, q)) {
            Object xSquare = this.field.multiply(p.x(), p.x());
            \u03bb = this.field.divide(this.field.add(xSquare, xSquare, xSquare, this.curve.getA()), this.field.add(p.y(), p.y()));
        } else {
            \u03bb = this.field.divide(this.field.subtract(q.y(), p.y()), this.field.subtract(q.x(), p.x()));
        }
        MultivariatePolynomial.Builder builder = new MultivariatePolynomial.Builder(2, this.field);
        builder.add(this.field.getIdentity(), new int[]{0, 1});
        builder.add(this.field.negate(\u03bb), new int[]{1, 0});
        builder.add(this.field.subtract(this.field.multiply(\u03bb, p.x()), p.y()), new int[]{0, 0});
        MultivariatePolynomial numerator = builder.build();
        builder = new MultivariatePolynomial.Builder(2, this.field);
        builder.add(this.field.getIdentity(), new int[]{1, 0});
        builder.add(this.field.subtract(this.field.add(p.x(), q.x()), this.field.multiply(\u03bb, \u03bb)), new int[]{0, 0});
        MultivariatePolynomial denominator = builder.build();
        return new Fraction((Object)numerator, (Object)denominator);
    }

    private E evaluate(Fraction<MultivariatePolynomial<E>> polynomial, AffinePoint<E> point) {
        Vector v = Vector.of((Object[])new Object[]{point.x(), point.y()});
        return (E)this.field.divide(((MultivariatePolynomial)polynomial.numerator()).apply(v, this.field), ((MultivariatePolynomial)polynomial.denominator()).apply(v, this.field));
    }
}

