/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.algorithms;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.algorithms.Power;
import dk.jonaslindstrom.ruffini.common.util.SamePair;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.ShortWeierstrassCurveAffine;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;

public class OptimalAtePairing<E1, E2, ET> {
    private final ShortWeierstrassCurveAffine<E2, ?> curve2;
    private final BigInteger p;
    private final BigInteger r;
    private final int k;
    private final Field<ET> ft;
    private final Function<E2, ET> g2embedding;
    private final Function<E1, E2> g1embedding;
    private final Function<AffinePoint<E1>, SamePair<ET>> twist;

    public OptimalAtePairing(Function<E1, E2> g1embedding, ShortWeierstrassCurveAffine<E2, ?> curve2, Function<E2, ET> g2embedding, Field<ET> ft, Function<AffinePoint<E1>, SamePair<ET>> twist, BigInteger p, BigInteger r, int k) {
        this.curve2 = curve2;
        this.ft = ft;
        this.p = p;
        this.r = r;
        this.k = k;
        this.g1embedding = g1embedding;
        this.g2embedding = g2embedding;
        this.twist = twist;
    }

    public ET lineFunction(AffinePoint<E2> Q1, AffinePoint<E2> Q2, AffinePoint<E1> P) {
        Object l;
        SamePair<ET> twist = this.twist.apply(P);
        Object field = this.curve2.getField();
        if (this.curve2.equals(Q1, Q2)) {
            l = field.divide(field.multiply(3, field.multiply(Q1.x(), Q1.x())), field.multiply(2, Q1.y()));
        } else {
            if (this.curve2.equals(Q1, this.curve2.negate(Q2))) {
                return (ET)this.ft.subtract(twist.first, this.g2embedding.apply(Q1.x()));
            }
            l = field.divide(field.subtract(Q2.y(), Q1.y()), field.subtract(Q2.x(), Q1.x()));
        }
        return (ET)this.ft.add(this.ft.multiply(this.g2embedding.apply(l), this.ft.subtract(twist.first, this.g2embedding.apply(Q1.x()))), this.ft.subtract(this.g2embedding.apply(Q1.y()), twist.second));
    }

    public ET pairing(AffinePoint<E1> P, AffinePoint<E2> Q, List<Integer> ci) {
        Object f = this.ft.getIdentity();
        AffinePoint T = Q;
        int L = ci.size() - 1;
        if (ci.get(L) == -1) {
            T = this.curve2.negate(T);
        }
        AffinePoint<E2> mQ = this.curve2.negate(Q);
        for (int i = L - 1; i >= 0; --i) {
            f = this.ft.multiply(f, f, this.lineFunction(T, T, P));
            T = this.curve2.add(T, T);
            if (ci.get(i) == 1) {
                f = this.ft.multiply(f, this.lineFunction(T, Q, P));
                T = this.curve2.add(T, Q);
                continue;
            }
            if (ci.get(i) != -1) continue;
            f = this.ft.multiply(f, this.lineFunction(T, mQ, P));
            T = (AffinePoint)this.curve2.subtract(T, Q);
        }
        BigInteger exponent = this.p.pow(this.k).subtract(BigInteger.ONE).divide(this.r);
        f = new Power(this.ft).apply(f, exponent);
        return (ET)f;
    }
}

