/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.algorithms;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.elliptic.algorithms.MillersAlgorithm;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.ShortWeierstrassCurveAffine;
import java.math.BigInteger;

public class WeilPairing<E> {
    private final ShortWeierstrassCurveAffine<E, ?> curve;
    private final Field<E> field;

    public WeilPairing(ShortWeierstrassCurveAffine<E, ?> curve) {
        this.curve = curve;
        this.field = curve.getField();
    }

    public E apply(AffinePoint<E> P, AffinePoint<E> Q, AffinePoint<E> S, int m) {
        return this.apply(P, Q, S, BigInteger.valueOf(m));
    }

    public E apply(AffinePoint<E> P, AffinePoint<E> Q, AffinePoint<E> S, BigInteger m) {
        MillersAlgorithm<E> millersAlgorithm = new MillersAlgorithm<E>(this.curve);
        E fPQS = millersAlgorithm.apply(P, this.curve.add(Q, S), m);
        E fPS = millersAlgorithm.apply(P, S, m);
        E fQPS = millersAlgorithm.apply(Q, (AffinePoint)this.curve.subtract(P, S), m);
        E fQS = millersAlgorithm.apply(Q, this.curve.negate(S), m);
        return (E)this.field.divide(this.field.multiply(fPQS, fQS), this.field.multiply(fPS, fQPS));
    }
}

