/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.elements;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.elliptic.elements.ProjectivePoint;
import java.util.Objects;
import java.util.function.Function;

public record AffinePoint<E>(E x, E y) {
    public static <F> AffinePoint<F> pointAtInfinity() {
        return new AffinePoint<Object>(null, null);
    }

    public boolean isPointAtInfinity() {
        return Objects.isNull(this.x) && Objects.isNull(this.y);
    }

    @Override
    public String toString() {
        if (this.isPointAtInfinity()) {
            return "O";
        }
        return String.format("(%s, %s)", this.x.toString(), this.y.toString());
    }

    public ProjectivePoint<E> toProjectivePoint(Field<E> field) {
        if (this.isPointAtInfinity()) {
            return ProjectivePoint.pointAtInfinity(field);
        }
        return new ProjectivePoint<Object>(this.x, this.y, field.getIdentity());
    }

    public <F> AffinePoint<F> apply(Function<E, F> function) {
        return new AffinePoint<F>(function.apply(this.x), function.apply(this.y));
    }
}

