/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.elements;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import java.util.function.Predicate;

public record JacobianPoint<E>(E X, E Y, E Z) {
    public static <F> JacobianPoint<F> pointAtInfinity(Field<F> field) {
        return new JacobianPoint<Object>(field.getZero(), field.getIdentity(), field.getZero());
    }

    public boolean isPointAtInfinity(Predicate<E> isZero) {
        return isZero.test(this.Z);
    }

    @Override
    public String toString() {
        return String.format("(%s : %s : %s)", this.X.toString(), this.Y.toString(), this.Z.toString());
    }

    public AffinePoint<E> toAffinePoint(Field<E> field) {
        if (this.isPointAtInfinity(arg_0 -> field.isZero(arg_0))) {
            return AffinePoint.pointAtInfinity();
        }
        Object zSquared = field.multiply(this.Z, this.Z);
        return new AffinePoint<Object>(field.divide(this.X, zSquared), field.divide(this.Y, zSquared));
    }
}

