/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.elements;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import java.util.function.Predicate;

public record ProjectivePoint<E>(E X, E Y, E Z) {
    public static <F> ProjectivePoint<F> pointAtInfinity(Field<F> field) {
        return new ProjectivePoint<Object>(field.getZero(), field.getIdentity(), field.getZero());
    }

    public boolean isPointAtInfinity(Predicate<E> isZero) {
        return isZero.test(this.Z);
    }

    @Override
    public String toString() {
        return String.format("[%s : %s : %s]", this.X.toString(), this.Y.toString(), this.Z.toString());
    }

    public AffinePoint<E> toAffinePoint(Field<E> field) {
        if (this.isPointAtInfinity(arg_0 -> field.isZero(arg_0))) {
            return AffinePoint.pointAtInfinity();
        }
        return new AffinePoint<Object>(field.divide(this.X, this.Z), field.divide(this.Y, this.Z));
    }
}

