/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures;

import dk.jonaslindstrom.ruffini.common.abstractions.AdditiveGroup;
import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.util.Pair;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.elements.EdwardsPoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.MontgomeryCurve;
import java.util.function.Function;

public class EdwardsCurve<E, F extends Field<E>>
implements AdditiveGroup<EdwardsPoint<E>> {
    private final F field;
    private final E d;

    public EdwardsCurve(F field, E d) {
        this.field = field;
        this.d = d;
    }

    public String toString(EdwardsPoint<E> a) {
        return a.toString();
    }

    public boolean equals(EdwardsPoint<E> a, EdwardsPoint<E> b) {
        return this.field.equals(a.x(), b.x()) && this.field.equals(a.y(), b.y());
    }

    @SafeVarargs
    private E multiply(E ... factors) {
        if (factors.length == 0) {
            return (E)this.field.getIdentity();
        }
        Object p = factors[0];
        for (int i = 1; i < factors.length; ++i) {
            p = this.field.multiply(p, factors[i]);
        }
        return p;
    }

    public EdwardsPoint<E> add(EdwardsPoint<E> a, EdwardsPoint<E> b) {
        Object n1 = this.field.add(this.field.multiply(a.x(), b.y()), this.field.multiply(a.y(), b.x()));
        Object n2 = this.field.subtract(this.field.multiply(a.y(), b.y()), this.field.multiply(a.x(), b.x()));
        Object p = this.multiply(this.d, a.x(), b.x(), a.y(), b.y());
        Object d1 = this.field.add(this.field.getIdentity(), p);
        Object d2 = this.field.subtract(this.field.getIdentity(), p);
        return new EdwardsPoint<Object>(this.field.divide(n1, d1), this.field.divide(n2, d2));
    }

    public EdwardsPoint<E> negate(EdwardsPoint<E> a) {
        return new EdwardsPoint<Object>(this.field.negate(a.x()), a.y());
    }

    public EdwardsPoint<E> getZero() {
        return new EdwardsPoint<Object>(this.field.getZero(), this.field.getIdentity());
    }

    public Pair<MontgomeryCurve<E, F>, Function<EdwardsPoint<E>, AffinePoint<E>>> getCorrespondingMontgomeryCurve() {
        Object e = this.field.subtract(this.field.getIdentity(), this.d);
        Object A = this.field.subtract(this.field.divide(this.field.integer(4), e), this.field.integer(2));
        Object B = this.field.invert(e);
        return Pair.of(new MontgomeryCurve<Object, F>(this.field, A, B), p -> {
            Object py = this.field.add(this.field.getIdentity(), p.y());
            Object my = this.field.subtract(this.field.getIdentity(), p.y());
            Object u = this.field.divide(py, my);
            Object v = this.field.divide(this.field.add(py, py), this.field.multiply(p.x(), my));
            return new AffinePoint<Object>(u, v);
        });
    }
}

