/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures;

import dk.jonaslindstrom.ruffini.common.abstractions.AdditiveGroup;
import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.algorithms.Multiply;
import dk.jonaslindstrom.ruffini.common.algorithms.Power;
import dk.jonaslindstrom.ruffini.common.util.Pair;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.ShortWeierstrassCurveAffine;
import dk.jonaslindstrom.ruffini.polynomials.elements.Polynomial;
import java.util.function.UnaryOperator;

public class MontgomeryCurve<E, F extends Field<E>>
implements AdditiveGroup<AffinePoint<E>> {
    protected final E A;
    protected final E B;
    protected final F field;

    public MontgomeryCurve(F field, E A, E B) {
        this.field = field;
        this.A = A;
        this.B = B;
        assert (!field.equals(this.discriminant(), field.getZero()));
    }

    public F getField() {
        return this.field;
    }

    public E discriminant() {
        return (E)this.field.multiply(this.B, this.field.subtract(this.field.multiply(this.A, this.A), this.field.integer(4)));
    }

    public E jInvariant() {
        Multiply multiply = new Multiply(this.field);
        Power power = new Power(this.field);
        return (E)this.field.divide(multiply.apply(Integer.valueOf(6912), power.apply(this.A, Integer.valueOf(3))), this.field.add(multiply.apply(Integer.valueOf(4), power.apply(this.A, Integer.valueOf(3))), multiply.apply(Integer.valueOf(27), power.apply(this.B, Integer.valueOf(2)))));
    }

    public String toString(AffinePoint<E> a) {
        return a.toString();
    }

    public boolean equals(AffinePoint<E> a, AffinePoint<E> b) {
        if (a.isPointAtInfinity()) {
            return b.isPointAtInfinity();
        }
        if (b.isPointAtInfinity()) {
            return a.isPointAtInfinity();
        }
        return this.field.equals(a.x(), b.x()) && this.field.equals(a.y(), b.y());
    }

    public AffinePoint<E> add(AffinePoint<E> p, AffinePoint<E> q) {
        Object \u03bb;
        if (p.isPointAtInfinity()) {
            return q;
        }
        if (q.isPointAtInfinity()) {
            return p;
        }
        if (!p.x().equals(q.x())) {
            \u03bb = this.field.divide(this.field.subtract(q.y(), p.y()), this.field.subtract(q.x(), p.x()));
        } else {
            if (this.field.equals(p.y(), this.field.negate(q.y()))) {
                return AffinePoint.pointAtInfinity();
            }
            \u03bb = this.field.divide(this.field.add(this.field.multiply(this.field.integer(3), this.field.multiply(p.x(), p.x())), this.field.multiply(this.field.integer(2), this.A, p.x()), this.field.getIdentity()), this.field.multiply(this.field.integer(2), this.B, p.y()));
        }
        Object x = this.field.subtract(this.field.multiply(this.B, this.field.multiply(\u03bb, \u03bb)), this.field.add(p.x(), q.x(), this.A));
        Object y = this.field.subtract(this.field.multiply(\u03bb, this.field.subtract(p.x(), x)), p.y());
        return new AffinePoint<Object>(x, y);
    }

    public AffinePoint<E> negate(AffinePoint<E> p) {
        return new AffinePoint<Object>(p.x(), this.field.negate(p.y()));
    }

    public AffinePoint<E> getZero() {
        return AffinePoint.pointAtInfinity();
    }

    public String toString() {
        Polynomial rhs = Polynomial.of((Object[])new Object[]{this.field.getZero(), this.field.getIdentity(), this.A, this.field.getIdentity()});
        Polynomial lhs = Polynomial.of((Object[])new Object[]{this.field.getZero(), this.field.getZero(), this.B});
        return "E: " + lhs.toString("y") + " = " + rhs.toString("x");
    }

    public E getA() {
        return this.A;
    }

    public E getB() {
        return this.B;
    }

    public Pair<ShortWeierstrassCurveAffine<E, F>, UnaryOperator<AffinePoint<E>>> getCorrespondingWeierstrassCurve() {
        Object a = this.field.divide(this.field.subtract(this.field.integer(3), this.field.power(this.A, 2)), this.field.multiply(3, this.field.power(this.B, 2)));
        Object b = this.field.divide(this.field.subtract(this.field.multiply(2, this.field.power(this.A, 3)), this.field.multiply(9, this.A)), this.field.multiply(27, this.field.power(this.B, 3)));
        return Pair.of(new ShortWeierstrassCurveAffine<Object, F>(this.field, a, b), p -> new AffinePoint<Object>(this.field.add(this.field.divide(p.x(), this.B), this.field.divide(this.A, this.field.multiply(3, this.B))), this.field.divide(p.y(), this.B)));
    }
}

