/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures;

import dk.jonaslindstrom.ruffini.common.abstractions.AdditiveGroup;
import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.algorithms.IntegerRingEmbedding;
import dk.jonaslindstrom.ruffini.common.algorithms.Multiply;
import dk.jonaslindstrom.ruffini.common.algorithms.Power;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;

public class ShortWeierstrassCurveAffine<E, F extends Field<E>>
implements AdditiveGroup<AffinePoint<E>> {
    private final E a;
    private final E b;
    private final E three;
    private final F field;

    public ShortWeierstrassCurveAffine(F field, E a, E b) {
        this.field = field;
        this.a = a;
        this.b = b;
        assert (!field.equals(this.discriminant(), field.getZero()));
        this.three = new IntegerRingEmbedding(field).apply(3);
    }

    public F getField() {
        return this.field;
    }

    public E discriminant() {
        Multiply multiply = new Multiply(this.field);
        Power power = new Power(this.field);
        return (E)this.field.negate(multiply.apply(Integer.valueOf(16), this.field.add(multiply.apply(Integer.valueOf(4), power.apply(this.a, Integer.valueOf(3))), multiply.apply(Integer.valueOf(27), this.field.multiply(this.b, this.b)))));
    }

    public String toString(AffinePoint<E> a) {
        return a.toString();
    }

    public boolean equals(AffinePoint<E> a, AffinePoint<E> b) {
        if (a.isPointAtInfinity()) {
            return b.isPointAtInfinity();
        }
        if (b.isPointAtInfinity()) {
            return a.isPointAtInfinity();
        }
        return this.field.equals(a.x(), b.x()) && this.field.equals(a.y(), b.y());
    }

    public AffinePoint<E> add(AffinePoint<E> p, AffinePoint<E> q) {
        Object s;
        if (p.isPointAtInfinity()) {
            return q;
        }
        if (q.isPointAtInfinity()) {
            return p;
        }
        if (this.field.equals(p.x(), q.x())) {
            if (this.field.equals(p.y(), this.field.negate(q.y()))) {
                return AffinePoint.pointAtInfinity();
            }
            s = this.field.divide(this.field.add(this.field.multiply(this.three, p.x(), p.x()), this.a), this.field.add(p.y(), p.y()));
        } else {
            s = this.field.divide(this.field.subtract(q.y(), p.y()), this.field.subtract(q.x(), p.x()));
        }
        Object x = this.field.subtract(this.field.multiply(s, s), this.field.add(p.x(), q.x()));
        Object y = this.field.subtract(this.field.multiply(s, this.field.subtract(p.x(), x)), p.y());
        return new AffinePoint<Object>(x, y);
    }

    public AffinePoint<E> negate(AffinePoint<E> p) {
        return new AffinePoint<Object>(p.x(), this.field.negate(p.y()));
    }

    public AffinePoint<E> getZero() {
        return AffinePoint.pointAtInfinity();
    }

    public String toString() {
        return String.format("E: y^2 = x^3 + %s x + %s", this.a, this.b);
    }

    public E getA() {
        return this.a;
    }

    public E getB() {
        return this.b;
    }
}

