/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures;

import dk.jonaslindstrom.ruffini.common.abstractions.AdditiveGroup;
import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.algorithms.Multiply;
import dk.jonaslindstrom.ruffini.common.algorithms.Power;
import dk.jonaslindstrom.ruffini.elliptic.elements.ProjectivePoint;

public class ShortWeierstrassCurveProjective<E>
implements AdditiveGroup<ProjectivePoint<E>> {
    private final E a;
    private final E b;
    private final ProjectivePoint<E> O;
    private final Field<E> field;

    public ShortWeierstrassCurveProjective(Field<E> field, E a, E b) {
        this.field = field;
        this.a = a;
        this.b = b;
        assert (!field.equals(this.discriminant(), field.getZero()));
        this.O = ProjectivePoint.pointAtInfinity(field);
    }

    public Field<E> getField() {
        return this.field;
    }

    public E discriminant() {
        Multiply multiply = new Multiply(this.field);
        Power power = new Power(this.field);
        return (E)this.field.negate(multiply.apply(Integer.valueOf(16), this.field.add(multiply.apply(Integer.valueOf(4), power.apply(this.a, Integer.valueOf(3))), multiply.apply(Integer.valueOf(27), this.field.multiply(this.b, this.b)))));
    }

    public E getA() {
        return this.a;
    }

    public E getB() {
        return this.b;
    }

    public ProjectivePoint<E> negate(ProjectivePoint<E> p) {
        return new ProjectivePoint<Object>(p.X(), this.field.negate(p.Y()), p.Z());
    }

    public ProjectivePoint<E> add(ProjectivePoint<E> p, ProjectivePoint<E> q) {
        Object u1 = this.field.multiply(p.X(), q.Z());
        Object u2 = this.field.multiply(q.X(), p.Z());
        Object s1 = this.field.multiply(p.Y(), q.Z());
        Object s2 = this.field.multiply(q.Y(), p.Z());
        Object zz = this.field.multiply(p.Z(), q.Z());
        Object t = this.field.add(u1, u2);
        Object tt = this.field.multiply(t, t);
        Object m = this.field.add(s1, s2);
        Object r = this.field.add(this.field.subtract(tt, this.field.multiply(u1, u2)), this.field.multiply(this.a, zz, zz));
        Object f = this.field.multiply(zz, m);
        Object l = this.field.multiply(m, f);
        Object ll = this.field.multiply(l, l);
        Object tpl = this.field.add(t, l);
        Object g = this.field.subtract(this.field.multiply(tpl, tpl), this.field.add(tt, ll));
        Object rr = this.field.multiply(r, r);
        Object w = this.field.subtract(this.field.doubling(rr), g);
        Object fw = this.field.multiply(f, w);
        Object x = this.field.doubling(fw);
        Object y = this.field.subtract(this.field.multiply(r, this.field.subtract(g, this.field.doubling(w))), this.field.doubling(ll));
        Object fff = this.field.multiply(f, f, f);
        Object z = this.field.add(fff, fff, fff, fff);
        return new ProjectivePoint<Object>(x, y, z);
    }

    public ProjectivePoint<E> getZero() {
        return this.O;
    }

    public String toString(ProjectivePoint<E> p) {
        return p.toString();
    }

    public boolean equals(ProjectivePoint<E> p, ProjectivePoint<E> q) {
        return this.field.equals(this.field.multiply(p.X(), q.Z()), this.field.multiply(q.X(), p.Z())) && this.field.equals(this.field.multiply(p.Y(), q.Z()), this.field.multiply(q.Y(), p.Z()));
    }

    public ProjectivePoint<E> doubling(ProjectivePoint<E> p) {
        Object xx = this.field.multiply(p.X(), p.X());
        Object zz = this.field.multiply(p.Z(), p.Z());
        Object w = this.field.add(this.field.multiply(this.a, zz), this.field.add(xx, xx, xx));
        Object yz = this.field.multiply(p.Y(), p.Z());
        Object s = this.field.doubling(yz);
        Object ss = this.field.multiply(s, s);
        Object sss = this.field.multiply(s, ss);
        Object r = this.field.multiply(p.Y(), s);
        Object rr = this.field.multiply(r, r);
        Object xpr = this.field.add(p.X(), r);
        Object b = this.field.subtract(this.field.multiply(xpr, xpr), this.field.add(xx, rr));
        Object h = this.field.subtract(this.field.multiply(w, w), this.field.doubling(b));
        Object x = this.field.multiply(h, s);
        Object y = this.field.subtract(this.field.multiply(w, this.field.subtract(b, h)), this.field.doubling(rr));
        Object z = sss;
        return new ProjectivePoint<Object>(x, y, z);
    }

    public String toString() {
        return "E: y^2 = x^3 + " + this.a + " x + " + this.b;
    }
}

