/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures.bls12381;

import dk.jonaslindstrom.ruffini.common.abstractions.Field;
import dk.jonaslindstrom.ruffini.common.abstractions.Group;
import dk.jonaslindstrom.ruffini.common.util.MathUtils;
import dk.jonaslindstrom.ruffini.common.util.SamePair;
import dk.jonaslindstrom.ruffini.elliptic.algorithms.OptimalAtePairing;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.ShortWeierstrassCurveAffine;
import dk.jonaslindstrom.ruffini.finitefields.AlgebraicFieldExtension;
import dk.jonaslindstrom.ruffini.finitefields.BigPrimeField;
import dk.jonaslindstrom.ruffini.polynomials.elements.Polynomial;
import java.math.BigInteger;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class BLS12381 {
    public static BigInteger p = new BigInteger("1a0111ea397fe69a4b1ba7b6434bacd764774b84f38512bf6730d2a0f6b0f6241eabfffeb153ffffb9feffffffffaaab", 16);
    public static BigPrimeField FP = new BigPrimeField(p);
    public static AlgebraicFieldExtension<BigInteger, BigPrimeField> FP2 = new AlgebraicFieldExtension((Field)FP, "u", Polynomial.of((Object[])new BigInteger[]{(BigInteger)FP.getIdentity(), (BigInteger)FP.getZero(), (BigInteger)FP.getIdentity()}));
    public static AlgebraicFieldExtension<Polynomial<BigInteger>, AlgebraicFieldExtension<BigInteger, BigPrimeField>> FP6 = new AlgebraicFieldExtension(FP2, "v", Polynomial.of((Object[])new Polynomial[]{(Polynomial)FP2.negate((Object)Polynomial.of((Object[])new BigInteger[]{(BigInteger)FP.getIdentity(), (BigInteger)FP.getIdentity()})), (Polynomial)FP2.getZero(), (Polynomial)FP2.getZero(), (Polynomial)FP2.getIdentity()}));
    public static AlgebraicFieldExtension<Polynomial<Polynomial<BigInteger>>, AlgebraicFieldExtension<Polynomial<BigInteger>, AlgebraicFieldExtension<BigInteger, BigPrimeField>>> FP12 = new AlgebraicFieldExtension(FP6, "w", Polynomial.of((Object[])new Polynomial[]{Polynomial.of((Object[])new Polynomial[]{(Polynomial)FP2.getZero(), (Polynomial)FP2.negate((Object)((Polynomial)FP2.getIdentity()))}), (Polynomial)FP6.getZero(), (Polynomial)FP6.getIdentity()}));
    public static Group<Polynomial<Polynomial<Polynomial<BigInteger>>>> GT = FP12;
    public static ShortWeierstrassCurveAffine<Polynomial<BigInteger>, ?> G2 = new ShortWeierstrassCurveAffine<Polynomial, AlgebraicFieldExtension<BigInteger, BigPrimeField>>(FP2, (Polynomial)FP2.getZero(), Polynomial.of((Object[])new BigInteger[]{BigInteger.valueOf(4L), BigInteger.valueOf(4L)}));
    public static ShortWeierstrassCurveAffine<BigInteger, ?> G1 = new ShortWeierstrassCurveAffine<BigInteger, BigPrimeField>(FP, BigInteger.ZERO, BigInteger.valueOf(4L));
    public static AffinePoint<Polynomial<BigInteger>> G2_GENERATOR = new AffinePoint<Polynomial>(Polynomial.of((Object[])new BigInteger[]{new BigInteger("024aa2b2f08f0a91260805272dc51051c6e47ad4fa403b02b4510b647ae3d1770bac0326a805bbefd48056c8c121bdb8", 16), new BigInteger("13e02b6052719f607dacd3a088274f65596bd0d09920b61ab5da61bbdc7f5049334cf11213945d57e5ac7d055d042b7e", 16)}), Polynomial.of((Object[])new BigInteger[]{new BigInteger("0ce5d527727d6e118cc9cdc6da2e351aadfd9baa8cbdd3a76d429a695160d12c923ac9cc3baca289e193548608b82801", 16), new BigInteger("0606c4a02ea734cc32acd2b02bc28b99cb3e287e85a763af267492ab572e99ab3f370d275cec1da1aaa9075ff05f79be", 16)}));
    public static BigInteger q = new BigInteger("73eda753299d7d483339d80809a1d80553bda402fffe5bfeffffffff00000001", 16);
    public static BigPrimeField FQ = new BigPrimeField(q);
    public static AffinePoint<BigInteger> G1_GENERATOR = new AffinePoint<BigInteger>(new BigInteger("17f1d3a73197d7942695638c4fa9ac0fc3688c4f9774b905a14e3a3f171bac586c55e83ff97a1aeffb3af00adb22c6bb", 16), new BigInteger("08b3f481e3aaa0f1a09e30ed741d8ae4fcf5e095d5d00af600db18cb2c04b3edd03cc744a2888ae40caa232946c5e7e1", 16));
    private static BigInteger t = new BigInteger("-d201000000010000", 16);
    private static List<Integer> ci = MathUtils.binaryExpansion((BigInteger)t.negate()).stream().map(x -> -x.intValue()).collect(Collectors.toList());
    public static BiFunction<AffinePoint<BigInteger>, AffinePoint<Polynomial<BigInteger>>, Polynomial<Polynomial<Polynomial<BigInteger>>>> PAIRING = (a, b) -> new OptimalAtePairing<BigInteger, Polynomial, Polynomial>(g1 -> FP2.embed(g1), (ShortWeierstrassCurveAffine<Polynomial, ?>)G2, g2 -> FP12.embed((Object)FP6.embed(g2)), (Field<Polynomial>)FP12, BLS12381::twist, p, q, 12).pairing((AffinePoint<BigInteger>)a, (AffinePoint<Polynomial>)b, ci);

    public static SamePair<Polynomial<Polynomial<Polynomial<BigInteger>>>> twist(AffinePoint<BigInteger> p) {
        return new SamePair((Object)Polynomial.of((Object[])new Polynomial[]{Polynomial.of((Object[])new Polynomial[]{(Polynomial)FP2.getZero(), Polynomial.of((Object[])new BigInteger[]{p.x()}), (Polynomial)FP2.getZero()}), Polynomial.constant((Object)((Polynomial)FP2.getZero()))}), (Object)Polynomial.of((Object[])new Polynomial[]{Polynomial.constant((Object)((Polynomial)FP2.getZero())), Polynomial.of((Object[])new Polynomial[]{(Polynomial)FP2.getZero(), Polynomial.of((Object[])new BigInteger[]{p.y()}), (Polynomial)FP2.getZero()})}));
    }
}

