/*
 * Decompiled with CFR 0.152.
 */
package dk.jonaslindstrom.ruffini.elliptic.structures.bls12381;

import dk.jonaslindstrom.ruffini.common.util.DataConversionPrimitives;
import dk.jonaslindstrom.ruffini.elliptic.elements.AffinePoint;
import dk.jonaslindstrom.ruffini.elliptic.structures.bls12381.BLS12381;
import dk.jonaslindstrom.ruffini.integers.algorithms.ModularSquareRoot;
import dk.jonaslindstrom.ruffini.polynomials.elements.Polynomial;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Serialization {
    private static Map<Group, Integer> size = Map.of(Group.G1, 2, Group.G2, 4);
    private final boolean C;
    private final boolean I;
    private final boolean S;
    private final List<BigInteger> integers;
    private final Group g;

    private Serialization(boolean C, boolean I, boolean S, List<BigInteger> integers, Group g) {
        this.C = C;
        this.I = I;
        this.S = S;
        this.integers = integers;
        this.g = g;
    }

    private static Serialization fromBytes(byte[] bytes, Group g) {
        return new Serialization((bytes[0] & 0x80) != 0, (bytes[0] & 0x40) != 0, (bytes[0] & 0x20) != 0, Serialization.getIntegers(Serialization.unmaskBytes(bytes)), g);
    }

    private static byte[] unmaskBytes(byte[] bytes) {
        byte[] copyOfBytes = Arrays.copyOf(bytes, bytes.length);
        copyOfBytes[0] = (byte)(copyOfBytes[0] & 0x1F);
        return copyOfBytes;
    }

    private static Serialization fromG2Point(AffinePoint<Polynomial<BigInteger>> point) {
        if (point.isPointAtInfinity()) {
            return new Serialization(false, true, false, List.of(), Group.G2);
        }
        return new Serialization(false, false, false, List.of((BigInteger)point.x().getCoefficient(0), (BigInteger)point.x().getCoefficient(1), (BigInteger)point.y().getCoefficient(0), (BigInteger)point.y().getCoefficient(1)), Group.G2);
    }

    private static Serialization fromG1Point(AffinePoint<BigInteger> point) {
        if (point.isPointAtInfinity()) {
            return new Serialization(false, true, false, List.of(), Group.G1);
        }
        return new Serialization(false, false, false, List.of(point.x(), point.y()), Group.G1);
    }

    private static List<BigInteger> getIntegers(byte[] bytes) {
        ArrayList<BigInteger> integers = new ArrayList<BigInteger>();
        for (int i = 0; i < bytes.length; i += 48) {
            integers.add(DataConversionPrimitives.OS2IP((byte[])Arrays.copyOfRange(bytes, i * 48, (i + 1) * 48)));
        }
        return integers;
    }

    public static byte[] serializeG1(AffinePoint<BigInteger> point, boolean compress) {
        boolean C = compress;
        boolean I = point.isPointAtInfinity();
        boolean S = compress && !I && point.y().compareTo(point.x()) > 0;
        byte m = (byte)((C ? 128 : 0) + (I ? 64 : 0) + (S ? 32 : 0));
        int length = compress ? 48 : 96;
        byte[] s = new byte[length];
        byte[] xString = I ? new byte[48] : DataConversionPrimitives.I2OSP((BigInteger)point.x(), (int)48);
        System.arraycopy(xString, 0, s, 0, 48);
        if (!compress) {
            byte[] yString = I ? new byte[48] : DataConversionPrimitives.I2OSP((BigInteger)point.y(), (int)48);
            System.arraycopy(yString, 0, s, 48, 48);
        }
        s[0] = (byte)(s[0] | m);
        return s;
    }

    public static AffinePoint<BigInteger> deserializeG1(byte[] bytes) {
        return Serialization.fromBytes(bytes, Group.G1).pointAsG1();
    }

    public static AffinePoint<Polynomial<BigInteger>> deserializeG2(byte[] bytes) {
        return Serialization.fromBytes(bytes, Group.G2).pointAsG2();
    }

    public static byte[] serializeG2(AffinePoint<Polynomial<BigInteger>> point, boolean compressed) {
        return Serialization.fromG2Point(point).getBytes(compressed);
    }

    private boolean isInfinity() {
        return this.I;
    }

    private boolean isCompressed() {
        return this.C;
    }

    private boolean yLargerThanX() {
        return this.S;
    }

    private byte[] getBytes(boolean compressed) {
        int integersToEncode = size.get((Object)this.g);
        if (compressed) {
            integersToEncode /= 2;
        }
        byte[] buffer = new byte[integersToEncode * 48];
        for (int i = 0; i < integersToEncode; ++i) {
            System.arraycopy(DataConversionPrimitives.I2OSP((BigInteger)this.integers.get(i), (int)48), 0, buffer, 48 * i, 48);
        }
        buffer[0] = (byte)(buffer[0] | (byte)((this.C ? 128 : 0) + (this.I ? 64 : 0) + (this.S ? 32 : 0)));
        return buffer;
    }

    private AffinePoint<BigInteger> pointAsG1() {
        BigInteger y;
        if (this.isInfinity()) {
            return AffinePoint.pointAtInfinity();
        }
        BigInteger x = this.integers.get(0);
        if (!this.isCompressed()) {
            y = this.integers.get(1);
        } else {
            ModularSquareRoot sqrt = new ModularSquareRoot(BLS12381.p);
            y = sqrt.apply(x.modPow(BigInteger.valueOf(3L), BLS12381.p).add(BigInteger.valueOf(4L)).mod(BLS12381.p));
            if (this.yLargerThanX() && y.compareTo(x) <= 0) {
                y = BLS12381.p.subtract(y);
            }
        }
        return new AffinePoint<BigInteger>(x, y);
    }

    private AffinePoint<Polynomial<BigInteger>> pointAsG2() {
        if (this.isInfinity()) {
            return AffinePoint.pointAtInfinity();
        }
        Polynomial x = Polynomial.of((Object[])new BigInteger[]{this.integers.get(0), this.integers.get(1)});
        Polynomial y = Polynomial.of((Object[])new BigInteger[]{this.integers.get(2), this.integers.get(3)});
        return new AffinePoint<Polynomial<BigInteger>>(x, y);
    }

    public static enum Group {
        G1,
        G2;

    }
}

