/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.hooks.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import dk.minepay.server.bukkit.classes.StoreItem;
import dk.minepay.server.bukkit.classes.StoreProduct;
import dk.minepay.server.bukkit.classes.StoreRequest;
import org.bukkit.event.Event;

public class ExprPrice
extends SimplePropertyExpression<StoreItem, Double> {
    private int pattern;
    private Expression<StoreRequest> request;
    private Expression<StoreProduct> product;

    public Double convert(StoreItem request) {
        if (request instanceof StoreProduct) {
            return ((StoreProduct)request).getPrice();
        }
        if (request instanceof StoreRequest) {
            return ((StoreRequest)request).getPrice();
        }
        return null;
    }

    protected String getPropertyName() {
        return "price of product/request";
    }

    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!(this.pattern != 0 && this.pattern != 1 || mode != Changer.ChangeMode.SET && mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.ADD)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Double.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.pattern == 0 || this.pattern == 1) {
            for (StoreProduct product : (StoreProduct[])this.product.getAll(event)) {
                if (product == null || delta == null || mode == null) {
                    return;
                }
                if (mode == Changer.ChangeMode.SET) {
                    product.setPrice((Double)delta[0]);
                    continue;
                }
                if (mode == Changer.ChangeMode.ADD) {
                    product.setPrice(product.getPrice() + (Double)delta[0]);
                    continue;
                }
                if (mode != Changer.ChangeMode.REMOVE) continue;
                product.setPrice(product.getPrice() - (Double)delta[0]);
            }
        }
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 0 || this.pattern == 1) {
            this.product = expressions[0];
        } else {
            this.request = expressions[0];
        }
        this.setExpr(expressions[0]);
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "price of product/request";
    }

    static {
        Skript.registerExpression(ExprPrice.class, Double.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] price of %products%", "%products%'s price", "[the] price of %requests%", "%requests%'s price"});
    }
}

