/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.managers;

import dk.minepay.gson.Gson;
import dk.minepay.gson.JsonArray;
import dk.minepay.gson.JsonObject;
import dk.minepay.okhttp3.HttpUrl;
import dk.minepay.okhttp3.MediaType;
import dk.minepay.okhttp3.OkHttpClient;
import dk.minepay.okhttp3.Request;
import dk.minepay.okhttp3.RequestBody;
import dk.minepay.okhttp3.Response;
import dk.minepay.server.bukkit.MinePayApi;
import dk.minepay.server.bukkit.classes.RequestStatus;
import dk.minepay.server.bukkit.classes.StoreProduct;
import dk.minepay.server.bukkit.classes.StoreRequest;
import dk.minepay.server.bukkit.classes.Vote;
import dk.minepay.server.bukkit.classes.VoteBody;
import dk.minepay.server.bukkit.classes.VoteStatus;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class RequestManager {
    private final OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
    private final String requestUrl = "https://api.mineclub.dk/v1/plugin/request/";
    private final String voteUrl = "https://api.mineclub.dk/v1/plugin/vote/";

    public JsonObject createRequest(UUID uuid, StoreProduct[] storeProducts) {
        Response response;
        MediaType mediaType = MediaType.parse("application/json");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("uuid", uuid.toString());
        JsonArray jsonArray = new JsonArray();
        for (StoreProduct storeProduct : storeProducts) {
            jsonArray.add(storeProduct.toJson());
        }
        jsonObject.add("products", jsonArray);
        RequestBody requestBody = RequestBody.create(mediaType, jsonObject.toString());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/request/")).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("POST", requestBody).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            return new Gson().fromJson(response.body().string(), JsonObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public StoreRequest[] getRequests(dk.minepay.server.bukkit.classes.RequestBody body) {
        Response response;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/request/")).newBuilder();
        for (RequestStatus requestStatus : body.getStatuses()) {
            urlBuilder.addQueryParameter("status", requestStatus.toString());
        }
        for (RequestStatus requestStatus : body.getServerStatuses()) {
            urlBuilder.addQueryParameter("serverStatus", requestStatus.toString());
        }
        Request request = new Request.Builder().url(urlBuilder.build()).method("GET", null).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            JsonObject jsonObject = new Gson().fromJson(response.body().string(), JsonObject.class);
            return new Gson().fromJson(jsonObject.get("data"), StoreRequest[].class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public StoreRequest getRequest(String requestId) {
        Response response;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/request/" + requestId)).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("GET", null).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            JsonObject jsonObject = new Gson().fromJson(response.body().string(), JsonObject.class);
            return new Gson().fromJson(jsonObject.get("data"), StoreRequest.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonObject acceptRequest(String requestId) {
        Response response;
        MediaType mediaType = MediaType.parse("application/json");
        JsonObject jsonObject = new JsonObject();
        RequestBody requestBody = RequestBody.create(mediaType, jsonObject.toString());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/request/" + requestId + "/accept")).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("POST", requestBody).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            return new Gson().fromJson(response.body().string(), JsonObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonObject cancelRequest(String requestId) {
        Response response;
        MediaType mediaType = MediaType.parse("application/json");
        JsonObject jsonObject = new JsonObject();
        RequestBody requestBody = RequestBody.create(mediaType, jsonObject.toString());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/request/" + requestId + "/cancel")).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("POST", requestBody).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            return new Gson().fromJson(response.body().string(), JsonObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Vote[] getVotes(VoteBody body) {
        Response response;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/vote/")).newBuilder();
        for (VoteStatus voteStatus : body.getStatuses()) {
            urlBuilder.addQueryParameter("status", voteStatus.toString());
        }
        if (body.getMcaccount() != null) {
            urlBuilder.addQueryParameter("mcaccount", body.getMcaccount().toString());
        }
        Request request = new Request.Builder().url(urlBuilder.build()).method("GET", null).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            JsonObject jsonObject = new Gson().fromJson(response.body().string(), JsonObject.class);
            return new Gson().fromJson(jsonObject.get("data"), Vote[].class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Vote getVote(String voteId) {
        Response response;
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/vote/" + voteId)).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("GET", null).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            JsonObject jsonObject = new Gson().fromJson(response.body().string(), JsonObject.class);
            return new Gson().fromJson(jsonObject.get("data"), Vote.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonObject acceptVote(String voteId) {
        Response response;
        MediaType mediaType = MediaType.parse("application/json");
        JsonObject jsonObject = new JsonObject();
        RequestBody requestBody = RequestBody.create(mediaType, jsonObject.toString());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://api.mineclub.dk/v1/plugin/vote/" + voteId + "/accept")).newBuilder();
        Request request = new Request.Builder().url(urlBuilder.build()).method("POST", requestBody).header("Authorization", "Bearer " + MinePayApi.getINSTANCE().getToken()).build();
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Response> callable = () -> this.client.newCall(request).execute();
            Future<Response> future = executor.submit(callable);
            response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        try {
            assert (response.body() != null);
            return new Gson().fromJson(response.body().string(), JsonObject.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Generated
    public String getVoteUrl() {
        return this.voteUrl;
    }
}

