/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.socketio.client;

import dk.minepay.okhttp3.Call;
import dk.minepay.okhttp3.WebSocket;
import dk.minepay.socketio.client.Manager;
import dk.minepay.socketio.client.Socket;
import dk.minepay.socketio.client.SocketOptionBuilder;
import dk.minepay.socketio.client.Url;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = 5;

    public static void setDefaultOkHttpWebSocketFactory(WebSocket.Factory factory) {
        Manager.defaultWebSocketFactory = factory;
    }

    public static void setDefaultOkHttpCallFactory(Call.Factory factory) {
        Manager.defaultCallFactory = factory;
    }

    private IO() {
    }

    public static Socket socket(String uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(String uri, Options opts) throws URISyntaxException {
        return IO.socket(new URI(uri), opts);
    }

    public static Socket socket(URI uri) {
        return IO.socket(uri, null);
    }

    public static Socket socket(URI uri, Options opts) {
        Manager io;
        if (opts == null) {
            opts = new Options();
        }
        Url.ParsedURI parsed = Url.parse(uri);
        URI source = parsed.uri;
        String id = parsed.id;
        boolean sameNamespace = managers.containsKey(id) && IO.managers.get((Object)id).nsps.containsKey(source.getPath());
        boolean newConnection = opts.forceNew || !opts.multiplex || sameNamespace;
        String query = source.getQuery();
        if (query != null && (opts.query == null || opts.query.isEmpty())) {
            opts.query = query;
        }
        if (newConnection) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("ignoring socket cache for %s", source));
            }
            io = new Manager(source, opts);
        } else {
            if (!managers.containsKey(id)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("new io instance for %s", source));
                }
                managers.putIfAbsent(id, new Manager(source, opts));
            }
            io = managers.get(id);
        }
        return io.socket(source.getPath(), opts);
    }

    public static class Options
    extends Manager.Options {
        public boolean forceNew;
        public boolean multiplex = true;

        public static SocketOptionBuilder builder() {
            return SocketOptionBuilder.builder();
        }
    }
}

