/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit;

import dk.minepay.server.bukkit.classes.RequestBody;
import dk.minepay.server.bukkit.classes.RequestStatus;
import dk.minepay.server.bukkit.classes.StoreRequest;
import dk.minepay.server.bukkit.classes.Vote;
import dk.minepay.server.bukkit.classes.VoteBody;
import dk.minepay.server.bukkit.classes.VoteStatus;
import dk.minepay.server.bukkit.listeners.JoinListener;
import dk.minepay.server.bukkit.managers.EventManager;
import dk.minepay.server.bukkit.managers.RequestManager;
import dk.minepay.server.bukkit.managers.SocketManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MinePayApi {
    private static final MinePayApi INSTANCE = new MinePayApi();
    private JavaPlugin plugin;
    private SocketManager socketManager;
    private RequestManager requestManager;
    private String token;

    public static MinePayApi initApi(JavaPlugin javaPlugin) {
        MinePayApi.getINSTANCE().init(javaPlugin);
        return MinePayApi.getINSTANCE();
    }

    public boolean isInitialized() {
        return this.plugin != null;
    }

    public void init(JavaPlugin javaPlugin) {
        if (this.isInitialized()) {
            return;
        }
        javaPlugin.getLogger().info("Initializing MinePayApi");
        this.token = System.getenv("TOKEN");
        this.plugin = javaPlugin;
        this.socketManager = new SocketManager();
        this.socketManager.init();
        new JoinListener();
        this.initRequestManager();
        this.checkFolders();
        this.loadOnline();
    }

    public void checkFolders() {
        File saves;
        File MinepayAPI = new File(this.plugin.getDataFolder().getParent(), "MinepayAPI");
        if (!MinepayAPI.exists()) {
            MinepayAPI.mkdir();
        }
        if (!(saves = new File(MinepayAPI, "saves.yml")).exists()) {
            try {
                saves.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void saveOnline() {
        File MinepayAPI = new File(this.plugin.getDataFolder().getParent(), "MinepayAPI");
        File saves = new File(MinepayAPI, "saves.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)saves);
        ArrayList<String> requests = new ArrayList<String>();
        ArrayList<String> votes = new ArrayList<String>();
        for (StoreRequest joinRequest : EventManager.requestsOnline) {
            requests.add(joinRequest.get_id());
        }
        for (Vote vote : EventManager.votesOnline) {
            votes.add(vote.get_id());
        }
        yamlConfiguration.set("requests", requests);
        yamlConfiguration.set("votes", votes);
        try {
            yamlConfiguration.save(saves);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadOnline() {
        File MinepayAPI = new File(this.plugin.getDataFolder().getParent(), "MinepayAPI");
        File saves = new File(MinepayAPI, "saves.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)saves);
        List requests = yamlConfiguration.getStringList("requests");
        List votes = yamlConfiguration.getStringList("votes");
        for (String request : requests) {
            StoreRequest joinRequest = this.requestManager.getRequest(request);
            EventManager.requestsOnline.add(joinRequest);
        }
        for (String vote : votes) {
            Vote vote1 = this.requestManager.getVote(vote);
            EventManager.votesOnline.add(vote1);
        }
        saves.delete();
    }

    public void disable() {
        if (this.socketManager != null) {
            this.socketManager.getSocket().close();
        }
        this.checkFolders();
        this.saveOnline();
    }

    public void initRequestManager() {
        this.requestManager = new RequestManager();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            StoreRequest[] requests = this.requestManager.getRequests(RequestBody.builder().statuses(Arrays.asList(RequestStatus.accepted, RequestStatus.cancelled)).serverStatuses(Collections.singletonList(RequestStatus.pending)).build());
            if (requests.length == 0) {
                return;
            }
            for (StoreRequest request : requests) {
                EventManager.callRequestEvent(request);
            }
            EventManager.calledIds.clear();
        }, 20L, 600L);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            Vote[] votes = this.requestManager.getVotes(VoteBody.builder().statuses(Collections.singletonList(VoteStatus.pending)).build());
            if (votes.length == 0) {
                return;
            }
            for (Vote vote : votes) {
                EventManager.callVoteEvent(vote);
            }
            EventManager.calledVoteIds.clear();
        }, 20L, 600L);
    }

    public static void runAsync(Runnable runnable) {
        MinePayApi.getINSTANCE().getPlugin().getServer().getScheduler().runTaskAsynchronously((Plugin)MinePayApi.getINSTANCE().getPlugin(), runnable);
    }

    @Generated
    public static MinePayApi getINSTANCE() {
        return INSTANCE;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }
}

