/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.classes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dk.minepay.server.bukkit.classes.StoreItem;
import java.util.HashMap;
import lombok.Generated;

public class StoreProduct
implements StoreItem {
    private String name;
    private String id;
    private double price;
    private double quantity;
    private HashMap<String, String> metadata = null;

    public StoreProduct() {
    }

    public StoreProduct(String name, String id, double price, double quantity, HashMap<String, String> metadata) {
        this.name = name;
        this.id = id;
        this.price = price;
        this.quantity = quantity;
        this.metadata = metadata;
    }

    public StoreProduct(String name, String id, double price, double quantity) {
        this.name = name;
        this.id = id;
        this.price = price;
        this.quantity = quantity;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("id", this.id);
        jsonObject.addProperty("price", (Number)this.price);
        jsonObject.addProperty("quantity", (Number)this.quantity);
        if (this.metadata != null) {
            JsonObject metadataObject = new JsonObject();
            for (String key : this.metadata.keySet()) {
                metadataObject.addProperty(key, this.metadata.get(key));
            }
            jsonObject.add("metadata", (JsonElement)metadataObject);
        }
        return jsonObject;
    }

    public String toString() {
        return "StoreProduct{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", price=" + this.price + ", quantity=" + this.quantity + ", metadata=" + this.metadata + '}';
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public double getQuantity() {
        return this.quantity;
    }

    @Generated
    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPrice(double price) {
        this.price = price;
    }

    @Generated
    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }
}

