/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.hooks.skript.expressions.product;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import dk.minepay.server.bukkit.classes.StoreProduct;
import org.bukkit.event.Event;

public class ExprQuantityOfProduct
extends SimplePropertyExpression<StoreProduct, Double> {
    public Double convert(StoreProduct request) {
        return request.getQuantity();
    }

    protected String getPropertyName() {
        return "quantity of product";
    }

    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Double.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        for (StoreProduct product : (StoreProduct[])this.getExpr().getArray(event)) {
            if (product == null || delta == null || mode == null) {
                return;
            }
            if (mode == Changer.ChangeMode.SET) {
                product.setQuantity((Double)delta[0]);
                continue;
            }
            if (mode == Changer.ChangeMode.ADD) {
                product.setQuantity(product.getQuantity() + (Double)delta[0]);
                continue;
            }
            if (mode != Changer.ChangeMode.REMOVE) continue;
            product.setQuantity(product.getQuantity() - (Double)delta[0]);
        }
    }

    public String toString(Event event, boolean debug) {
        return "quantity of product";
    }

    static {
        ExprQuantityOfProduct.register(ExprQuantityOfProduct.class, Double.class, (String)"quantity", (String)"product");
    }
}

