/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.hooks.skript.expressions.requests;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dk.minepay.server.bukkit.MinePayApi;
import dk.minepay.server.bukkit.classes.RequestBody;
import dk.minepay.server.bukkit.classes.RequestStatus;
import dk.minepay.server.bukkit.classes.StoreRequest;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;

public class ExprRequestsWithStatus
extends SimpleExpression<StoreRequest> {
    private Expression<String> status;
    private Expression<String> serverStatus;

    protected StoreRequest[] get(Event event) {
        RequestStatus requestStatus;
        ArrayList<RequestStatus> statuses = new ArrayList<RequestStatus>();
        ArrayList<RequestStatus> serverStatuses = new ArrayList<RequestStatus>();
        for (String status : (String[])this.status.getAll(event)) {
            requestStatus = RequestStatus.fromString(status);
            if (requestStatus == null) continue;
            statuses.add(requestStatus);
        }
        for (String serverStatus : (String[])this.serverStatus.getAll(event)) {
            requestStatus = RequestStatus.fromString(serverStatus);
            if (requestStatus == null) continue;
            serverStatuses.add(requestStatus);
        }
        RequestBody requestBody = RequestBody.builder().statuses(statuses).serverStatuses(serverStatuses).build();
        if (serverStatuses.isEmpty() && statuses.isEmpty()) {
            return new StoreRequest[0];
        }
        return (StoreRequest[])Arrays.stream(MinePayApi.getINSTANCE().getRequestManager().getRequests(requestBody)).toArray(StoreRequest[]::new);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends StoreRequest> getReturnType() {
        return StoreRequest.class;
    }

    public String toString(Event event, boolean debug) {
        return "requests with status";
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.status = expressions[0];
        this.serverStatus = expressions[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprRequestsWithStatus.class, StoreRequest.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"request[s] with status %strings%[ and serverstatus %strings%]"});
    }
}

