/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.managers;

import dk.minepay.server.bukkit.MinePayApi;
import dk.minepay.server.bukkit.classes.RequestStatus;
import dk.minepay.server.bukkit.classes.StoreRequest;
import dk.minepay.server.bukkit.classes.Vote;
import dk.minepay.server.bukkit.events.StoreRequestAcceptEvent;
import dk.minepay.server.bukkit.events.StoreRequestAcceptOnlineEvent;
import dk.minepay.server.bukkit.events.StoreRequestCancelEvent;
import dk.minepay.server.bukkit.events.StoreRequestCancelOnlineEvent;
import dk.minepay.server.bukkit.events.VoteEvent;
import dk.minepay.server.bukkit.events.VoteOnlineEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EventManager {
    public static HashSet<String> calledIds = new HashSet();
    public static HashSet<String> calledVoteIds = new HashSet();
    public static List<StoreRequest> requestsOnline = new ArrayList<StoreRequest>();
    public static List<Vote> votesOnline = new ArrayList<Vote>();

    public static void callRequestEvent(StoreRequest storeRequest) {
        if (calledIds.contains(storeRequest.get_id())) {
            return;
        }
        OfflinePlayer player = MinePayApi.getINSTANCE().getPlugin().getServer().getOfflinePlayer(storeRequest.getUuid());
        calledIds.add(storeRequest.get_id());
        if (player.isOnline()) {
            EventManager.callOnlineRequestEvent(storeRequest);
        } else {
            requestsOnline.add(storeRequest);
        }
        if (storeRequest.getStatus().equals((Object)RequestStatus.accepted)) {
            StoreRequestAcceptEvent event = new StoreRequestAcceptEvent(storeRequest, player);
            MinePayApi.runAsync(() -> {
                MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event);
                calledIds.remove(storeRequest.get_id());
            });
        } else if (storeRequest.getStatus().equals((Object)RequestStatus.cancelled)) {
            StoreRequestCancelEvent event = new StoreRequestCancelEvent(storeRequest, player);
            MinePayApi.runAsync(() -> {
                MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event);
                calledIds.remove(storeRequest.get_id());
            });
        }
    }

    public static void callVoteEvent(Vote vote) {
        if (calledVoteIds.contains(vote.get_id())) {
            return;
        }
        OfflinePlayer player = MinePayApi.getINSTANCE().getPlugin().getServer().getOfflinePlayer(vote.getUuid());
        calledVoteIds.add(vote.get_id());
        if (player.isOnline()) {
            EventManager.callOnlineVoteEvent(vote);
        } else {
            votesOnline.add(vote);
        }
        VoteEvent event = new VoteEvent(vote, player);
        MinePayApi.runAsync(() -> {
            MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event);
            calledVoteIds.remove(vote.get_id());
        });
    }

    public static void callOnlineVoteEvent(Vote vote) {
        Player player = MinePayApi.getINSTANCE().getPlugin().getServer().getPlayer(vote.getUuid());
        VoteOnlineEvent event = new VoteOnlineEvent(vote, player);
        MinePayApi.runAsync(() -> MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event));
        votesOnline.remove(vote);
    }

    public static void callOnlineRequestEvent(StoreRequest storeRequest) {
        Player player = MinePayApi.getINSTANCE().getPlugin().getServer().getPlayer(storeRequest.getUuid());
        if (storeRequest.getStatus().equals((Object)RequestStatus.accepted)) {
            StoreRequestAcceptOnlineEvent event = new StoreRequestAcceptOnlineEvent(storeRequest, player);
            MinePayApi.runAsync(() -> MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event));
        } else if (storeRequest.getStatus().equals((Object)RequestStatus.cancelled)) {
            StoreRequestCancelOnlineEvent event = new StoreRequestCancelOnlineEvent(storeRequest, player);
            MinePayApi.runAsync(() -> MinePayApi.getINSTANCE().getPlugin().getServer().getPluginManager().callEvent((Event)event));
        }
        requestsOnline.remove(storeRequest);
    }

    public static List<StoreRequest> getRequestsOnlineByUUID(UUID player) {
        ArrayList<StoreRequest> requests = new ArrayList<StoreRequest>();
        for (StoreRequest request : requestsOnline) {
            if (!request.getUuid().equals(player)) continue;
            requests.add(request);
        }
        return requests;
    }

    public static List<Vote> getVotesOnlineByUUID(UUID player) {
        ArrayList<Vote> votes = new ArrayList<Vote>();
        for (Vote vote : votesOnline) {
            if (!vote.getUuid().equals(player)) continue;
            votes.add(vote);
        }
        return votes;
    }
}

