/*
 * Decompiled with CFR 0.152.
 */
package dk.minepay.server.bukkit.managers;

import com.google.gson.Gson;
import dk.minepay.server.bukkit.MinePayApi;
import dk.minepay.server.bukkit.classes.StoreRequest;
import dk.minepay.server.bukkit.classes.Vote;
import dk.minepay.server.bukkit.managers.EventManager;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import lombok.Generated;

public class SocketManager {
    private Socket socket;

    public void init() {
        HashMap<String, String> auth = new HashMap<String, String>();
        auth.put("token", MinePayApi.getINSTANCE().getToken());
        auth.put("type", "plugins");
        IO.Options options = IO.Options.builder().setAuth(auth).build();
        try {
            this.socket = IO.socket((String)"https://api.mineclub.dk", (IO.Options)options);
            this.socket.on("connect", args -> MinePayApi.getINSTANCE().getPlugin().getLogger().info("Socket.io connected."));
            this.socket.on("disconnect", args -> MinePayApi.getINSTANCE().getPlugin().getLogger().info("Socket.io disconnected."));
            this.socket.on("connect_error", args -> MinePayApi.getINSTANCE().getPlugin().getLogger().severe("Socket.io connection error: " + Arrays.toString(args)));
            this.socket.on("storeRequest", args -> {
                StoreRequest storeRequest = (StoreRequest)new Gson().fromJson(args[0].toString(), StoreRequest.class);
                EventManager.callRequestEvent(storeRequest);
            });
            this.socket.on("vote", args -> {
                Vote vote = (Vote)new Gson().fromJson(args[0].toString(), Vote.class);
                EventManager.callVoteEvent(vote);
            });
            this.socket.connect();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public Socket getSocket() {
        return this.socket;
    }
}

