/*
 * Decompiled with CFR 0.152.
 */
package dk.sebsa.mana.impl;

import dk.sebsa.mana.LogFormatter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FormatterImpl
implements LogFormatter {
    public String formatTrace = "TRC: %s";
    public String formatLog = "LOG: %s";
    public String formatWarn = "WARN: %s";
    public String formatErr = "ERR: %s";
    private DateTimeFormatter dtf;
    private final boolean formatDate;

    public FormatterImpl(String ft, String fl, String fw, String fe) {
        this.formatLog = fl.replace("%ft", ft).replace("%fw", fw).replace("%fe", fe);
        this.formatTrace = ft.replace("%fl", fl).replace("%fw", fw).replace("%fe", fe);
        this.formatWarn = fw.replace("%fl", fl).replace("%ft", ft).replace("%fe", fe);
        this.formatErr = fe.replace("%fl", fl).replace("%fw", fw).replace("%ft", ft);
        this.formatDate = fl.contains("%d");
        this.dtf = this.formatDate ? DateTimeFormatter.ofPattern("HH:mm:ss") : null;
    }

    public FormatterImpl() {
        this.formatDate = false;
    }

    public String format(String format, Object o, String className) {
        String result = format.replace("%s", o.toString()).replace("%c", className).replace("%t", Thread.currentThread().getName());
        if (this.formatDate) {
            return result.replace("%d", this.dtf.format(LocalDateTime.now()));
        }
        return result;
    }

    @Override
    public String formatTrace(Object o) {
        return this.format(this.formatTrace, o, "Mana");
    }

    @Override
    public String formatLog(Object o) {
        return this.format(this.formatLog, o, "Mana");
    }

    @Override
    public String formatWarn(Object o) {
        return this.format(this.formatWarn, o, "Mana");
    }

    @Override
    public String formatErr(Object o) {
        return this.format(this.formatErr, o, "Mana");
    }
}

