/*
 * Decompiled with CFR 0.152.
 */
package dk.syddjurs.camel.component.taxon;

import dk.syddjurs.camel.component.taxon.TaxonService;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public final class TaxonUtil {
    private TaxonUtil() {
    }

    public static String buildInputText(TaxonService taxonService, Exchange exchange) throws TypeConversionException, NoTypeConversionAvailableException {
        StringBuilder sb = new StringBuilder();
        if (ObjectHelper.isNotEmpty((Object)taxonService.getSubject())) {
            sb.append(taxonService.getSubject());
            sb.append("\r\n");
        }
        if (ObjectHelper.isNotEmpty((Object)taxonService.getText())) {
            sb.append(taxonService.getText());
        } else {
            sb.append((String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange.getIn().getBody()));
        }
        return sb.toString();
    }

    public static Exchange buildExchange(Exchange exchange, String taxonFullResult) {
        exchange.getIn().setHeader("CamelTaxonFullResult", (Object)taxonFullResult);
        try {
            Iterator taxonClasses;
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(taxonFullResult);
            String status = rootNode.get("status").get("status").asText();
            exchange.getIn().setHeader("CamelTaxonStatus", (Object)status);
            if (status.equals("OK") && (taxonClasses = rootNode.get("classes").getFields()).hasNext()) {
                Map.Entry taxonClass = (Map.Entry)taxonClasses.next();
                exchange.getIn().setHeader("CamelTaxonClass", taxonClass.getKey());
                exchange.getIn().setHeader("CamelTaxonTitle", (Object)((JsonNode)taxonClass.getValue()).get("title").asText());
                exchange.getIn().setHeader("CamelTaxonScoreTotal", (Object)((JsonNode)taxonClass.getValue()).get("scoreTotal").asInt());
                exchange.getIn().setHeader("CamelTaxonConfidenceCoefficient", (Object)((JsonNode)taxonClass.getValue()).get("scoreConfidenceCoefficient").asInt());
            }
            if (status.equals("Error")) {
                exchange.getIn().setHeader("CamelTaxonError", (Object)rootNode.get("status").get("errors").toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exchange;
    }
}

