/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros;

import burlap.oomdp.core.states.State;
import burlap.oomdp.singleagent.Action;
import burlap.oomdp.singleagent.GroundedAction;
import burlap.oomdp.singleagent.environment.Environment;
import burlap.oomdp.singleagent.environment.EnvironmentOutcome;
import burlap.ros.actionpub.ActionPublisher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ros.RosBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRosEnvironment
implements Environment {
    protected RosBridge rosBridge;
    protected Map<String, ActionPublisher> actionPublishers = new HashMap<String, ActionPublisher>();
    protected double lastReward = 0.0;

    public AbstractRosEnvironment(RosBridge rosBridge) {
        this.rosBridge = rosBridge;
    }

    public AbstractRosEnvironment(String rosBridgeURI) {
        this.rosBridge = RosBridge.createConnection((String)rosBridgeURI);
        this.rosBridge.waitForConnection();
    }

    public void setActionPublisher(String actionName, ActionPublisher ap) {
        this.actionPublishers.put(actionName, ap);
    }

    public void setActionPublisher(Action action, ActionPublisher ap) {
        this.actionPublishers.put(action.getName(), ap);
    }

    public void setActionPublisherForMultipleAcitons(List<Action> actions, ActionPublisher ap) {
        for (Action a : actions) {
            this.setActionPublisher(a, ap);
        }
    }

    public void setActionPublisherForMultipleAcitonNames(List<String> actionNames, ActionPublisher ap) {
        for (String a : actionNames) {
            this.setActionPublisher(a, ap);
        }
    }

    public RosBridge getRosBridge() {
        return this.rosBridge;
    }

    public EnvironmentOutcome executeAction(GroundedAction ga) {
        State startState = this.getCurrentObservation();
        ActionPublisher ap = this.actionPublishers.get(ga.actionName());
        if (ap == null) {
            throw new RuntimeException("AbstractRosEnvironment has no ActionPublisher available to handle action " + ga.toString());
        }
        int delay = ap.publishAction(ga);
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        State finalState = this.getCurrentObservation();
        this.lastReward = this.getMostRecentRewardSignal(startState, ga, finalState);
        EnvironmentOutcome eo = new EnvironmentOutcome(startState, ga, finalState, this.lastReward, this.isInTerminalState());
        if (this.isInTerminalState()) {
            this.handleEnterTerminalState();
        }
        return eo;
    }

    public double getLastReward() {
        return this.lastReward;
    }

    public void resetEnvironment() {
        this.lastReward = 0.0;
    }

    protected abstract double getMostRecentRewardSignal(State var1, GroundedAction var2, State var3);

    protected abstract void handleEnterTerminalState();
}

