/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros;

import burlap.debugtools.DPrint;
import burlap.oomdp.auxiliary.common.NullTermination;
import burlap.oomdp.core.Attribute;
import burlap.oomdp.core.Domain;
import burlap.oomdp.core.TerminalFunction;
import burlap.oomdp.core.objects.MutableObjectInstance;
import burlap.oomdp.core.objects.ObjectInstance;
import burlap.oomdp.core.states.MutableState;
import burlap.oomdp.core.states.State;
import burlap.oomdp.singleagent.GroundedAction;
import burlap.oomdp.singleagent.RewardFunction;
import burlap.oomdp.singleagent.common.NullRewardFunction;
import burlap.oomdp.singleagent.environment.Environment;
import burlap.oomdp.singleagent.environment.EnvironmentOutcome;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ros.Publisher;
import ros.RosBridge;
import ros.RosListenDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AsynchronousRosEnvironment
implements Environment,
RosListenDelegate {
    protected Domain domain;
    protected RosBridge rosBridge;
    protected Publisher actionPub;
    protected int actionSleepMS;
    protected State curState;
    protected boolean addHeader = false;
    protected RewardFunction rf = new NullRewardFunction();
    protected TerminalFunction tf = new NullTermination();
    protected double lastReward = 0.0;
    protected Boolean receivedFirstState = false;
    protected boolean printStateAsReceived = false;
    protected int debugCode = 7345252;

    public AsynchronousRosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic, String rosActionTopic, int actionSleepMS) {
        this.domain = domain;
        this.rosBridge = RosBridge.createConnection((String)rosBridgeURI);
        this.rosBridge.waitForConnection();
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this);
        this.actionPub = new Publisher(rosActionTopic, "std_msgs/String", this.rosBridge);
        this.actionSleepMS = actionSleepMS;
    }

    public AsynchronousRosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic, String rosActionTopic, int actionSleepMS, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        this.domain = domain;
        this.rosBridge = RosBridge.createConnection((String)rosBridgeURI);
        this.rosBridge.waitForConnection();
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
        this.actionPub = new Publisher(rosActionTopic, "std_msgs/String", this.rosBridge);
        this.actionSleepMS = actionSleepMS;
    }

    public AsynchronousRosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic, String rosActionTopic, String rosStateTopicMessageType, String rosActionTopicMessageType, int actionSleepMS, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        this.domain = domain;
        this.rosBridge = RosBridge.createConnection((String)rosBridgeURI);
        this.rosBridge.waitForConnection();
        this.rosBridge.subscribe(rosStateTopic, rosStateTopicMessageType, (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
        this.actionPub = new Publisher(rosActionTopic, rosActionTopicMessageType, this.rosBridge);
        this.actionSleepMS = actionSleepMS;
    }

    public RosBridge getRosBridge() {
        return this.rosBridge;
    }

    public void setRewardFunction(RewardFunction rf) {
        this.rf = rf;
    }

    public void setTerminalFunction(TerminalFunction tf) {
        this.tf = tf;
    }

    public State getCurrentObservation() {
        return this.curState.copy();
    }

    public boolean isInTerminalState() {
        return this.tf.isTerminal(this.curState);
    }

    public void resetEnvironment() {
    }

    public void setPrintStateAsReceived(boolean printStateAsReceived) {
        this.printStateAsReceived = printStateAsReceived;
    }

    public void setAddHeader(boolean addHeader) {
        this.addHeader = addHeader;
    }

    public synchronized void blockUntilStateReceived() {
        DPrint.cl((int)this.debugCode, (String)"Blocking until state received.");
        while (!this.receivedFirstState.booleanValue()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        DPrint.cl((int)this.debugCode, (String)"State received");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(JsonNode data, String stringRep) {
        JsonNode burlapObjects = data.get("msg").get("objects");
        State s = this.JSONToState(burlapObjects);
        this.curState = this.onStateReceive(s);
        if (!this.receivedFirstState.booleanValue()) {
            AsynchronousRosEnvironment asynchronousRosEnvironment = this;
            synchronized (asynchronousRosEnvironment) {
                this.receivedFirstState = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void receive(Map<String, Object> data, String stringRep) {
        Map msgContent = (Map)data.get("msg");
        List burlapObjects = (List)msgContent.get("objects");
        State s = this.JSONPreparedToState(burlapObjects);
        this.curState = this.onStateReceive(s);
        if (!this.receivedFirstState.booleanValue()) {
            AsynchronousRosEnvironment asynchronousRosEnvironment = this;
            synchronized (asynchronousRosEnvironment) {
                this.receivedFirstState = true;
                this.notifyAll();
            }
        }
    }

    protected State onStateReceive(State s) {
        if (this.printStateAsReceived) {
            System.out.println(s.getCompleteStateDescription() + "\n-------------------------");
        }
        return s;
    }

    public EnvironmentOutcome executeAction(GroundedAction ga) {
        State startState = this.curState;
        String astr = ga.toString();
        HashMap<String, Object> strData = new HashMap<String, Object>();
        if (this.addHeader) {
            Map<String, Object> header = this.getHeader();
            strData.put("header", header);
        }
        strData.put("data", astr);
        this.actionPub.publish(strData);
        try {
            Thread.sleep(this.actionSleepMS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        State finalState = this.curState.copy();
        this.lastReward = this.rf.reward(startState, ga, finalState);
        EnvironmentOutcome eo = new EnvironmentOutcome(startState, ga, finalState, this.lastReward, this.tf.isTerminal(finalState));
        return eo;
    }

    public double getLastReward() {
        return this.lastReward;
    }

    public Map<String, Object> getHeader() {
        return new HashMap<String, Object>();
    }

    protected State JSONToState(JsonNode objects) {
        MutableState s = new MutableState();
        Iterator objIter = objects.elements();
        while (objIter.hasNext()) {
            JsonNode obj = (JsonNode)objIter.next();
            String obName = obj.get("name").asText();
            String className = obj.get("object_class").asText();
            MutableObjectInstance ob = new MutableObjectInstance(this.domain.getObjectClass(className), obName);
            JsonNode values = obj.get("values");
            Iterator valueIter = values.elements();
            while (valueIter.hasNext()) {
                String[] targets;
                JsonNode v = (JsonNode)valueIter.next();
                String aname = v.get("attribute").asText();
                String vv = v.get("value").asText();
                if (this.domain.getAttribute((String)aname).type != Attribute.AttributeType.MULTITARGETRELATIONAL) {
                    ob.setValue(aname, vv);
                    continue;
                }
                for (String t : targets = vv.split(",")) {
                    ob.addRelationalTarget(aname, t);
                }
            }
            s.addObject((ObjectInstance)ob);
        }
        return s;
    }

    @Deprecated
    protected State JSONPreparedToState(List<Map<String, Object>> objects) {
        MutableState s = new MutableState();
        for (Map<String, Object> oMap : objects) {
            String obName = (String)oMap.get("name");
            String className = (String)oMap.get("object_class");
            MutableObjectInstance ob = new MutableObjectInstance(this.domain.getObjectClass(className), obName);
            List values = (List)oMap.get("values");
            for (Map v : values) {
                String[] targets;
                String aname = (String)v.get("attribute");
                String vv = (String)v.get("value");
                if (this.domain.getAttribute((String)aname).type != Attribute.AttributeType.MULTITARGETRELATIONAL) {
                    ob.setValue(aname, vv);
                    continue;
                }
                for (String t : targets = vv.split(",")) {
                    ob.addRelationalTarget(aname, t);
                }
            }
            s.addObject((ObjectInstance)ob);
        }
        return s;
    }
}

