/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros;

import burlap.debugtools.DPrint;
import burlap.oomdp.auxiliary.common.NullTermination;
import burlap.oomdp.core.Domain;
import burlap.oomdp.core.TerminalFunction;
import burlap.oomdp.core.states.State;
import burlap.oomdp.singleagent.GroundedAction;
import burlap.oomdp.singleagent.RewardFunction;
import burlap.oomdp.singleagent.common.NullRewardFunction;
import burlap.oomdp.stateserialization.simple.SimpleSerializableState;
import burlap.ros.AbstractRosEnvironment;
import com.fasterxml.jackson.databind.JsonNode;
import ros.RosBridge;
import ros.RosListenDelegate;
import ros.tools.MessageUnpacker;

public class RosEnvironment
extends AbstractRosEnvironment
implements RosListenDelegate {
    protected Domain domain;
    protected State curState;
    protected RewardFunction rf = new NullRewardFunction();
    protected TerminalFunction tf = new NullTermination();
    protected Boolean receivedFirstState = false;
    protected boolean printStateAsReceived = false;
    protected int debugCode = 7345252;

    public RosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic) {
        super(rosBridgeURI);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this);
    }

    public RosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        super(rosBridgeURI);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
    }

    public RosEnvironment(Domain domain, String rosBridgeURI, String rosStateTopic, String rosStateMessageType, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        super(rosBridgeURI);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, rosStateMessageType, (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
    }

    public RosEnvironment(Domain domain, RosBridge ros, String rosStateTopic) {
        super(ros);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this);
    }

    public RosEnvironment(Domain domain, RosBridge ros, String rosStateTopic, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        super(ros);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, "burlap_msgs/burlap_state", (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
    }

    public RosEnvironment(Domain domain, RosBridge ros, String rosStateTopic, String rosStateMessageType, int rosBridgeThrottleRate, int rosBridgeQueueLength) {
        super(ros);
        this.domain = domain;
        this.rosBridge.subscribe(rosStateTopic, rosStateMessageType, (RosListenDelegate)this, rosBridgeThrottleRate, rosBridgeQueueLength);
    }

    public void setRewardFunction(RewardFunction rf) {
        this.rf = rf;
    }

    public void setTerminalFunction(TerminalFunction tf) {
        this.tf = tf;
    }

    public State getCurrentObservation() {
        this.blockUntilStateReceived();
        return this.curState.copy();
    }

    public boolean isInTerminalState() {
        return this.tf.isTerminal(this.curState);
    }

    protected double getMostRecentRewardSignal(State s, GroundedAction ga, State sprime) {
        return this.rf.reward(s, ga, sprime);
    }

    public void setPrintStateAsReceived(boolean printStateAsReceived) {
        this.printStateAsReceived = printStateAsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overrideFirstReceivedState(State s) {
        this.curState = s;
        this.receivedFirstState = true;
        RosEnvironment rosEnvironment = this;
        synchronized (rosEnvironment) {
            this.notifyAll();
        }
    }

    public synchronized void blockUntilStateReceived() {
        if (!this.receivedFirstState.booleanValue()) {
            DPrint.cl((int)this.debugCode, (String)"Blocking until state received.");
        }
        boolean oldReceived = this.receivedFirstState;
        while (!this.receivedFirstState.booleanValue()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!oldReceived) {
            DPrint.cl((int)this.debugCode, (String)"State received");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(JsonNode data, String stringRep) {
        State s = this.unpackStateFromMsg(data, stringRep);
        this.curState = this.onStateReceive(s);
        if (!this.receivedFirstState.booleanValue()) {
            RosEnvironment rosEnvironment = this;
            synchronized (rosEnvironment) {
                this.receivedFirstState = true;
                this.notifyAll();
            }
        }
    }

    public State unpackStateFromMsg(JsonNode data, String stringRep) {
        MessageUnpacker unpacker = new MessageUnpacker(SimpleSerializableState.class);
        SimpleSerializableState sss = (SimpleSerializableState)unpacker.unpackRosMessage(data);
        State s = sss.deserialize(this.domain);
        return s;
    }

    protected State onStateReceive(State s) {
        if (this.printStateAsReceived) {
            System.out.println(s.getCompleteStateDescription() + "\n-------------------------");
        }
        return s;
    }

    protected void handleEnterTerminalState() {
    }
}

