/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros;

import burlap.mdp.core.action.Action;
import burlap.mdp.core.action.ActionType;
import burlap.mdp.core.state.State;
import burlap.mdp.singleagent.environment.Environment;
import burlap.mdp.singleagent.environment.EnvironmentOutcome;
import burlap.ros.actionpub.ActionPublisher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ros.RosBridge;

public abstract class AbstractRosEnvironment
implements Environment {
    protected RosBridge rosBridge;
    protected Map<String, ActionPublisher> actionPublishers = new HashMap<String, ActionPublisher>();
    protected double lastReward = 0.0;

    public AbstractRosEnvironment(RosBridge rosBridge) {
        this.rosBridge = rosBridge;
    }

    public AbstractRosEnvironment(String rosBridgeURI) {
        this.rosBridge = RosBridge.createConnection((String)rosBridgeURI);
        this.rosBridge.waitForConnection();
    }

    public void setActionPublisher(String actionName, ActionPublisher ap) {
        this.actionPublishers.put(actionName, ap);
    }

    public void setActionPublisher(ActionType action, ActionPublisher ap) {
        this.actionPublishers.put(action.typeName(), ap);
    }

    public void setActionPublisherForMultipleActions(List<ActionType> actions, ActionPublisher ap) {
        for (ActionType a : actions) {
            this.setActionPublisher(a, ap);
        }
    }

    public void setActionPublisherForMultipleAcitonNames(List<String> actionNames, ActionPublisher ap) {
        for (String a : actionNames) {
            this.setActionPublisher(a, ap);
        }
    }

    public RosBridge getRosBridge() {
        return this.rosBridge;
    }

    public EnvironmentOutcome executeAction(Action a) {
        State startState = this.currentObservation();
        ActionPublisher ap = this.actionPublishers.get(a.actionName());
        if (ap == null) {
            throw new RuntimeException("AbstractRosEnvironment has no ActionPublisher available to handle action " + a.toString());
        }
        int delay = ap.publishAction(a);
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        State finalState = this.currentObservation();
        this.lastReward = this.getMostRecentRewardSignal(startState, a, finalState);
        EnvironmentOutcome eo = new EnvironmentOutcome(startState, a, finalState, this.lastReward, this.isInTerminalState());
        if (this.isInTerminalState()) {
            this.handleEnterTerminalState();
        }
        return eo;
    }

    public double lastReward() {
        return this.lastReward;
    }

    public void resetEnvironment() {
        this.lastReward = 0.0;
    }

    protected abstract double getMostRecentRewardSignal(State var1, Action var2, State var3);

    protected abstract void handleEnterTerminalState();
}

