/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros;

import burlap.debugtools.MyTimer;
import burlap.shell.BurlapShell;
import burlap.shell.command.ShellCommand;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import ros.RosBridge;
import ros.RosListenDelegate;
import ros.SubscriptionRequestMsg;

public class RosShellCommand
implements ShellCommand {
    protected OptionParser parser = new OptionParser("rt:f:h*");
    protected RosBridge ros;

    public RosShellCommand(RosBridge ros) {
        this.ros = ros;
    }

    public String commandName() {
        return "ros";
    }

    public int call(BurlapShell shell, String argString, Scanner is, final PrintStream os) {
        String[] parsed = this.parseWithQuotesAndEscapedQuotes(argString);
        OptionSet oset = this.parser.parse(parsed);
        List args = oset.nonOptionArguments();
        if (oset.has("h")) {
            os.println("ros pub topic msg_type msg\nros send msg\nros echo [-r][-t time_out][-f fragment_size] topic [msg_type]\n\nFor publishing, the msg is the JSON formatted string of the ROS message. You will probably need to enclose the message in single quotes if there are spaces. Uses backslash for escape single quotes. For example, ros pub my_topic std_msgs/String '{\"data\": \"hello world!\"}'.\n\nsend will send a raw message to the rosbridge server. You will need to make sure that the message format adheres to the Rosbridge JSON message protocol. Like with publish, you may need to enclose the message with single quotes if there are spaces and use escape single quotes.\n\nFor echo, the message type is optional, but if it is not present and the topic does not already exist on ROS, echo will fail to receive data. Rosbridge may also fail if you don't privde the message type and it's the first time you've published to it.\n By default echo will only print the next message received, use -r to continually print every subsequent message. To regain control of the shell when echo set to repeat, hit enter. If not repeating, you can set a time out to have control return with the -t option. By default time out is set to 10 seconds.");
            return 0;
        }
        if (args.size() < 2) {
            return -1;
        }
        if (((String)args.get(0)).equals("pub")) {
            if (args.size() != 4) {
                return -1;
            }
            this.ros.publishJsonMsg((String)args.get(1), (String)args.get(2), (String)args.get(3));
        } else if (((String)args.get(0)).equals("send")) {
            if (args.size() != 2) {
                return -1;
            }
            this.ros.sendRawMessage((String)args.get(1));
        } else if (((String)args.get(0)).equals("echo")) {
            if (args.size() != 3 && args.size() != 2) {
                return -1;
            }
            final String topic = (String)args.get(1);
            String pmsgType = null;
            if (args.size() == 3) {
                pmsgType = (String)args.get(2);
            }
            String msgType = pmsgType;
            boolean repeat = oset.has("r");
            double ptimeout = 10.0;
            if (oset.has("t")) {
                ptimeout = Double.parseDouble((String)oset.valueOf("t"));
            }
            final double timeout = ptimeout;
            SubscriptionRequestMsg sub = SubscriptionRequestMsg.generate((String)topic).setType(msgType).setQueueLength(Integer.valueOf(1)).setThrottleRate(Integer.valueOf(1));
            if (oset.has("f")) {
                int fragSize = Integer.parseInt((String)oset.valueOf("f"));
                sub.setFragmentSize(Integer.valueOf(fragSize));
            }
            if (!repeat) {
                final SingleEchoer echoer = new SingleEchoer(os, this);
                this.ros.subscribe(sub, (RosListenDelegate)echoer);
                Thread echoThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MyTimer time = new MyTimer(true);
                        RosShellCommand rosShellCommand = RosShellCommand.this;
                        synchronized (rosShellCommand) {
                            while (!echoer.done && time.peekAtTime() < timeout) {
                                try {
                                    RosShellCommand.this.wait((long)(timeout * 1000.0));
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        time.stop();
                        if (time.getTime() > timeout) {
                            os.println("Timed out... Consider providing ros message type if you have not subscribed to this topic before.");
                        }
                        RosShellCommand.this.ros.removeListener(topic, (RosListenDelegate)echoer);
                    }
                });
                echoThread.start();
                try {
                    echoThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                RosListenDelegate echoer = new RosListenDelegate(){

                    public void receive(JsonNode data, String stringRep) {
                        JsonNode rosMsgNode = data.get("msg");
                        String msgFormat = rosMsgNode.toString();
                        os.println(msgFormat);
                    }
                };
                this.ros.subscribe(sub, echoer);
                is.nextLine();
                this.ros.removeListener(topic, echoer);
            }
        }
        return 0;
    }

    protected String[] parseWithQuotesAndEscapedQuotes(String input) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^']\\S*|'.+?(?<!\\\\)')\\s*").matcher(input);
        while (m.find()) {
            String match = m.group(1).replace("\\'", "'");
            if (match.startsWith("'") && match.endsWith("'")) {
                match = match.substring(1, match.length() - 1);
            }
            list.add(match);
        }
        String[] array = list.toArray(new String[list.size()]);
        return array;
    }

    protected class SingleEchoer
    implements RosListenDelegate {
        PrintStream os;
        public boolean done = false;
        Object lock;

        public SingleEchoer(PrintStream os, Object lock) {
            this.os = os;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(JsonNode data, String stringRep) {
            JsonNode rosMsgNode = data.get("msg");
            String msgFormat = rosMsgNode.toString();
            this.os.println(msgFormat);
            this.done = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

