/*
 * Decompiled with CFR 0.152.
 */
package burlap.ros.actionpub;

import burlap.mdp.core.action.Action;
import burlap.ros.actionpub.ActionPublisher;
import java.util.Timer;
import java.util.TimerTask;
import ros.Publisher;
import ros.RosBridge;

public class RepeatingActionPublisher
extends ActionPublisher.DirectActionPublisher {
    protected Object msg;
    protected int period;
    protected int n;
    protected boolean synchronous;
    protected int delayTime = 0;

    public RepeatingActionPublisher(String topic, String msgType, RosBridge rosBridge, Object msg, int period, int n, boolean synchronous) {
        super(topic, msgType, rosBridge);
        this.msg = msg;
        this.period = period;
        this.n = n;
        this.synchronous = synchronous;
        if (synchronous) {
            this.delayTime = period;
        }
    }

    public RepeatingActionPublisher(String topic, String msgType, RosBridge rosBridge, Object msg, int period, int n, boolean synchronous, int delayTime) {
        super(topic, msgType, rosBridge);
        this.msg = msg;
        this.period = period;
        this.n = n;
        this.synchronous = synchronous;
        this.delayTime = delayTime;
    }

    public RepeatingActionPublisher(Publisher pub, Object msg, int period, int n, boolean synchronous) {
        super(pub);
        this.msg = msg;
        this.period = period;
        this.n = n;
        this.synchronous = synchronous;
    }

    public RepeatingActionPublisher(Publisher pub, Object msg, int period, int n, boolean synchronous, int delayTime) {
        super(pub);
        this.msg = msg;
        this.period = period;
        this.n = n;
        this.synchronous = synchronous;
        this.delayTime = delayTime;
    }

    public Object getMsg() {
        return this.msg;
    }

    public void setMsg(Object msg) {
        this.msg = msg;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int publishAction(Action a) {
        Timer timer = new Timer();
        PublishTask pt = new PublishTask();
        timer.schedule((TimerTask)pt, 0L, (long)this.period);
        if (this.synchronous) {
            PublishTask publishTask = pt;
            synchronized (publishTask) {
                while (!pt.finished()) {
                    try {
                        pt.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.delayTime;
    }

    protected class PublishTask
    extends TimerTask {
        int nRemain;

        public PublishTask() {
            this.nRemain = RepeatingActionPublisher.this.n;
        }

        public boolean finished() {
            return this.nRemain <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RepeatingActionPublisher.this.publish(RepeatingActionPublisher.this.msg);
            --this.nRemain;
            if (this.nRemain <= 0) {
                this.cancel();
                PublishTask publishTask = this;
                synchronized (publishTask) {
                    this.notifyAll();
                }
            }
        }
    }
}

