/*
 * Decompiled with CFR 0.152.
 */
package ros;

import ros.RosBridge;

public class Publisher {
    protected String topic;
    protected String msgType;
    protected RosBridge rosBridge;

    public Publisher(String topic, String msgType, RosBridge rosBridge) {
        this.topic = topic;
        this.msgType = msgType;
        this.rosBridge = rosBridge;
        this.rosBridge.advertise(this.topic, this.msgType);
    }

    public Publisher(String topic, String msgType, RosBridge rosBridge, boolean advertiseNow) {
        this.topic = topic;
        this.msgType = msgType;
        this.rosBridge = rosBridge;
        if (advertiseNow) {
            this.rosBridge.advertise(this.topic, this.msgType);
        }
    }

    public void advertise() {
        this.rosBridge.advertise(this.topic, this.msgType);
    }

    public void publish(Object msg) {
        this.rosBridge.publish(this.topic, this.msgType, msg);
    }

    public void publishJsonMsg(String jsonMsg) {
        this.rosBridge.publishJsonMsg(this.topic, this.msgType, jsonMsg);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public RosBridge getRosBridge() {
        return this.rosBridge;
    }
}

