/*
 * Decompiled with CFR 0.152.
 */
package ros;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import ros.RosListenDelegate;
import ros.SubscriptionRequestMsg;

@WebSocket
public class RosBridge {
    protected final CountDownLatch closeLatch;
    protected Session session;
    protected Map<String, RosBridgeSubscriber> listeners = new HashMap<String, RosBridgeSubscriber>();
    protected Set<String> publishedTopics = new HashSet<String>();
    protected Map<String, FragmentManager> fragementManagers = new HashMap<String, FragmentManager>();
    protected boolean hasConnected = false;
    protected boolean printMessagesAsReceived = false;

    public static RosBridge createConnection(String rosBridgeURI) {
        RosBridge socket = new RosBridge();
        socket.connect(rosBridgeURI);
        return socket;
    }

    public void connect(String rosBridgeURI) {
        WebSocketClient client = new WebSocketClient();
        try {
            client.start();
            URI echoUri = new URI(rosBridgeURI);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            client.connect((Object)this, echoUri, request);
            System.out.printf("Connecting to : %s%n", echoUri);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void connect(String rosBridgeURI, boolean waitForConnection) {
        WebSocketClient client = new WebSocketClient();
        try {
            client.start();
            URI echoUri = new URI(rosBridgeURI);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            client.connect((Object)this, echoUri, request);
            System.out.printf("Connecting to : %s%n", echoUri);
            if (waitForConnection) {
                this.waitForConnection();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public RosBridge() {
        this.closeLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnection() {
        if (this.hasConnected) {
            return;
        }
        RosBridge rosBridge = this;
        synchronized (rosBridge) {
            while (!this.hasConnected) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean hasConnected() {
        return this.hasConnected;
    }

    public boolean printMessagesAsReceived() {
        return this.printMessagesAsReceived;
    }

    public void setPrintMessagesAsReceived(boolean printMessagesAsReceived) {
        this.printMessagesAsReceived = printMessagesAsReceived;
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        System.out.printf("Connection closed: %d - %s%n", statusCode, reason);
        this.session = null;
        this.closeLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketConnect
    public void onConnect(Session session) {
        System.out.printf("Got connect for ros: %s%n", session);
        this.session = session;
        this.hasConnected = true;
        RosBridge rosBridge = this;
        synchronized (rosBridge) {
            this.notifyAll();
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        if (this.printMessagesAsReceived) {
            System.out.println(msg);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = null;
        try {
            node = mapper.readTree(msg);
            if (node.has("op")) {
                String op = node.get("op").asText();
                if (op.equals("publish")) {
                    String topic = node.get("topic").asText();
                    RosBridgeSubscriber subscriber = this.listeners.get(topic);
                    if (subscriber != null) {
                        subscriber.receive(node, msg);
                    }
                } else if (op.equals("fragment")) {
                    this.processFragment(node);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Could not parse ROSBridge web socket message into JSON data");
            e.printStackTrace();
        }
    }

    public void subscribe(String topic, String type, RosListenDelegate delegate) {
        this.subscribe(SubscriptionRequestMsg.generate(topic).setType(type), delegate);
    }

    public void subscribe(String topic, String type, RosListenDelegate delegate, int throttleRate, int queueLength) {
        this.subscribe(SubscriptionRequestMsg.generate(topic).setType(type).setThrottleRate(throttleRate).setQueueLength(queueLength), delegate);
    }

    public void subscribe(SubscriptionRequestMsg request, RosListenDelegate delegate) {
        String topic = request.getTopic();
        if (this.listeners.containsKey(topic)) {
            this.listeners.get(topic).addDelegate(delegate);
            return;
        }
        this.listeners.put(topic, new RosBridgeSubscriber(delegate));
        String subMsg = request.generateJsonString();
        try {
            Future fut = this.session.getRemote().sendStringByFuture(subMsg);
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            System.out.println("Error in sending subscription message to Rosbridge host for topic " + topic);
            t.printStackTrace();
        }
    }

    public void removeListener(String topic, RosListenDelegate delegate) {
        RosBridgeSubscriber subscriber = this.listeners.get(topic);
        if (subscriber != null) {
            subscriber.removeDelegate(delegate);
            if (subscriber.numDelegates() == 0) {
                this.unsubscribe(topic);
            }
        }
    }

    public void advertise(String topic, String type) {
        if (!this.publishedTopics.contains(topic)) {
            String adMsg = "{\"op\": \"advertise\",\n\"topic\": \"" + topic + "\",\n" + "\"type\": \"" + type + "\"\n" + "}";
            try {
                Future fut = this.session.getRemote().sendStringByFuture(adMsg);
                fut.get(2L, TimeUnit.SECONDS);
                this.publishedTopics.add(topic);
            }
            catch (Throwable t) {
                System.out.println("Error in setting up advertisement to " + topic + " with message type: " + type);
                t.printStackTrace();
            }
        }
    }

    public void unsubscribe(String topic) {
        String usMsg = "{\"op\": \"unsubscribe\",\n\"topic\": \"" + topic + "\"\n" + "}";
        try {
            Future fut = this.session.getRemote().sendStringByFuture(usMsg);
            fut.get(2L, TimeUnit.SECONDS);
            this.publishedTopics.add(topic);
        }
        catch (Throwable t) {
            System.out.println("Error in sending unsubscribe message for " + topic);
            t.printStackTrace();
        }
        this.listeners.remove(topic);
    }

    public void publish(String topic, String type, Object msg) {
        this.advertise(topic, type);
        HashMap<String, Object> jsonMsg = new HashMap<String, Object>();
        jsonMsg.put("op", "publish");
        jsonMsg.put("topic", topic);
        jsonMsg.put("type", type);
        jsonMsg.put("msg", msg);
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter writer = new StringWriter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)writer);
            objectMapper.writeValue(jsonGenerator, jsonMsg);
        }
        catch (Exception e) {
            System.out.println("Error");
        }
        String jsonMsgString = writer.toString();
        try {
            Future fut = this.session.getRemote().sendStringByFuture(jsonMsgString);
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            System.out.println("Error publishing to " + topic + " with message type: " + type);
            t.printStackTrace();
        }
    }

    public void publishJsonMsg(String topic, String type, String jsonMsg) {
        this.advertise(topic, type);
        String fullMsg = "{\"op\": \"publish\", \"topic\": \"" + topic + "\", \"type\": \"" + type + "\", " + "\"msg\": " + jsonMsg + "}";
        try {
            Future fut = this.session.getRemote().sendStringByFuture(fullMsg);
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            System.out.println("Error publishing to " + topic + " with message type: " + type);
            t.printStackTrace();
        }
    }

    public void sendRawMessage(String message) {
        try {
            Future fut = this.session.getRemote().sendStringByFuture(message);
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            System.out.println("Error sending raw message to RosBridge server: " + message);
            t.printStackTrace();
        }
    }

    public void formatAndSend(Object o) {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter writer = new StringWriter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)writer);
            objectMapper.writeValue(jsonGenerator, o);
        }
        catch (Exception e) {
            System.out.println("Error parsing object into a JSON message.");
        }
        String jsonMsgString = writer.toString();
        try {
            Future fut = this.session.getRemote().sendStringByFuture(jsonMsgString);
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            System.out.println("Error sending message to RosBridge server: " + jsonMsgString);
            t.printStackTrace();
        }
    }

    protected void processFragment(JsonNode node) {
        boolean complete;
        String id = node.get("id").textValue();
        FragmentManager manager = this.fragementManagers.get(id);
        if (manager == null) {
            manager = new FragmentManager(node);
            this.fragementManagers.put(id, manager);
        }
        if (complete = manager.updateFragment(node)) {
            String fullMsg = manager.generateFullMessage();
            this.fragementManagers.remove(id);
            this.onMessage(fullMsg);
        }
    }

    public static class FragmentManager {
        protected String id;
        protected String[] fragments;
        protected Set<Integer> completedFragements;

        public FragmentManager(JsonNode fragmentJson) {
            int total = fragmentJson.get("total").intValue();
            this.fragments = new String[total];
            this.completedFragements = new HashSet<Integer>(total);
            this.id = fragmentJson.get("id").textValue();
        }

        public boolean updateFragment(JsonNode fragmentJson) {
            String data = fragmentJson.get("data").asText();
            int num = fragmentJson.get("num").intValue();
            this.fragments[num] = data;
            this.completedFragements.add(num);
            return this.complete();
        }

        public boolean complete() {
            return this.completedFragements.size() == this.fragments.length;
        }

        public int numFragments() {
            return this.fragments.length;
        }

        public int numCompletedFragments() {
            return this.completedFragements.size();
        }

        public String generateFullMessage() {
            if (!this.complete()) {
                throw new RuntimeException("Cannot generate full message from fragments, because not all fragments have arrived.");
            }
            StringBuilder buf = new StringBuilder(this.fragments[0].length() * this.fragments.length);
            for (String frag : this.fragments) {
                buf.append(frag);
            }
            return buf.toString();
        }
    }

    public static class RosBridgeSubscriber {
        protected List<RosListenDelegate> delegates = new ArrayList<RosListenDelegate>();

        public RosBridgeSubscriber() {
        }

        public RosBridgeSubscriber(RosListenDelegate ... delegates) {
            for (RosListenDelegate delegate : delegates) {
                this.delegates.add(delegate);
            }
        }

        public void addDelegate(RosListenDelegate delegate) {
            this.delegates.add(delegate);
        }

        public void removeDelegate(RosListenDelegate delegate) {
            this.delegates.remove(delegate);
        }

        public void receive(JsonNode data, String stringRep) {
            for (RosListenDelegate delegate : this.delegates) {
                delegate.receive(data, stringRep);
            }
        }

        public int numDelegates() {
            return this.delegates.size();
        }
    }
}

