/*
 * Decompiled with CFR 0.152.
 */
package ros.msgs.sensor_msgs;

import java.awt.image.BufferedImage;
import ros.msgs.std_msgs.Header;

public class Image {
    public Header header;
    public int height;
    public int width;
    public String encoding;
    public int is_bigendian;
    public int step;
    public byte[] data;

    public Image() {
    }

    public Image(Header header, int height, int width, String encoding, int is_bigendian, int step, byte[] data) {
        this.header = header;
        this.height = height;
        this.width = width;
        this.encoding = encoding;
        this.is_bigendian = is_bigendian;
        this.step = step;
        this.data = data;
    }

    public BufferedImage toBufferedImage() {
        if (this.encoding.equals("bgr8") || this.encoding.equals("rgb8")) {
            return this.toBufferedImageFromRGB8();
        }
        if (this.encoding.equals("mono8")) {
            return this.toBufferedImageFromMono8();
        }
        throw new RuntimeException("ROS Image does not currently decode " + this.encoding + ". See Java doc for support types.");
    }

    protected BufferedImage toBufferedImageFromMono8() {
        int w = this.width;
        int h = this.height;
        BufferedImage i = new BufferedImage(w, h, 1);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int index = y * w + x;
                int anded = this.data[index++] & 0xFF;
                int rgb = anded | anded << 8 | anded << 16 | 0xFF000000;
                i.setRGB(x, y, rgb);
            }
        }
        return i;
    }

    protected BufferedImage toBufferedImageFromRGB8() {
        int w = this.width;
        int h = this.height;
        BufferedImage i = new BufferedImage(w, h, 1);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int rgb;
                int index = y * w * 3 + x * 3;
                if (this.encoding.equals("bgr8")) {
                    rgb = this.data[index++] & 0xFF | (this.data[index++] & 0xFF) << 8 | (this.data[index++] & 0xFF) << 16 | 0xFF000000;
                } else if (this.encoding.equals("rgb8")) {
                    rgb = (this.data[index++] & 0xFF) << 16 | (this.data[index++] & 0xFF) << 8 | this.data[index++] & 0xFF | 0xFF000000;
                } else {
                    throw new RuntimeException("ROS Image toBufferedImageFromRGB8 does not decode " + this.encoding);
                }
                i.setRGB(x, y, rgb);
            }
        }
        return i;
    }
}

