/*
 * Decompiled with CFR 0.152.
 */
package ros.tools;

import java.util.Timer;
import java.util.TimerTask;
import ros.Publisher;
import ros.RosBridge;

public class PeriodicPublisher {
    protected Publisher pub;
    protected volatile Object msg = null;
    protected int period = -1;
    protected PublisherTimerTask timerTask;

    public PeriodicPublisher(String topic, String msgType, RosBridge rosBridge) {
        this.pub = new Publisher(topic, msgType, rosBridge);
    }

    public PeriodicPublisher(String topic, String msgType, RosBridge rosBridge, Object msg) {
        this.pub = new Publisher(topic, msgType, rosBridge);
    }

    public PeriodicPublisher(Publisher pub) {
        this.pub = pub;
    }

    public PeriodicPublisher(Publisher pub, Object msg) {
        this.pub = pub;
        this.msg = msg;
    }

    public Publisher getPub() {
        return this.pub;
    }

    public void setPub(Publisher pub) {
        this.pub = pub;
    }

    public Object getMsg() {
        return this.msg;
    }

    public void setMsg(Object msg) {
        if (msg == null && this.timerTask != null) {
            System.out.println("PeriodicPublisher is not setting message because new message is null and publisher is currently publishing.");
        }
        this.msg = msg;
    }

    public int getPublishingPeriod() {
        return this.period;
    }

    public void cancelPublishing() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
            this.period = -1;
        }
    }

    public boolean isPublishing() {
        return this.timerTask != null;
    }

    public void beginPublishing(int period) {
        if (this.msg == null) {
            throw new RuntimeException("Cannot begin publishing because the message to publish is unset. Use the setMsg method or beginPublishing(Object msg, int period)");
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new PublisherTimerTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.timerTask, 0L, (long)period);
    }

    public void beginPublishing(Object msg, int period) {
        this.msg = msg;
        this.beginPublishing(period);
    }

    protected class PublisherTimerTask
    extends TimerTask {
        protected PublisherTimerTask() {
        }

        public void run() {
            PeriodicPublisher.this.pub.publish(PeriodicPublisher.this.msg);
        }
    }
}

