/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.fasterxml.jackson.databind.JsonNode;
import ros.Publisher;
import ros.RosBridge;
import ros.RosListenDelegate;
import ros.SubscriptionRequestMsg;
import ros.msgs.std_msgs.PrimitiveMsg;
import ros.tools.MessageUnpacker;

public class RosTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Need the rosbridge websocket URI provided as argument. For example:\n\tws://localhost:9090");
            System.exit(0);
        }
        RosBridge bridge = new RosBridge();
        bridge.connect(args[0], true);
        bridge.subscribe(SubscriptionRequestMsg.generate("/ros_to_java").setType("std_msgs/String").setThrottleRate(1).setQueueLength(1), new RosListenDelegate(){

            public void receive(JsonNode data, String stringRep) {
                MessageUnpacker unpacker = new MessageUnpacker(PrimitiveMsg.class);
                PrimitiveMsg msg = (PrimitiveMsg)unpacker.unpackRosMessage(data);
                System.out.println((String)msg.data);
            }
        });
        Publisher pub = new Publisher("/java_to_ros", "std_msgs/String", bridge);
        for (int i = 0; i < 100; ++i) {
            pub.publish(new PrimitiveMsg<String>("hello from java " + i));
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

