/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.tjw.item.spark;

import edu.columbia.tjw.item.ItemCurveFactory;
import edu.columbia.tjw.item.ItemSettings;
import edu.columbia.tjw.item.base.SimpleRegressor;
import edu.columbia.tjw.item.base.SimpleStatus;
import edu.columbia.tjw.item.base.StandardCurveFactory;
import edu.columbia.tjw.item.base.StandardCurveType;
import edu.columbia.tjw.item.util.EnumFamily;
import edu.columbia.tjw.item.util.EnumMember;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ItemClassifierSettings
implements Serializable {
    private static final long serialVersionUID = -4137037306764905399L;
    public ItemSettings _settings;
    private final SimpleStatus _fromStatus;
    private final SimpleRegressor _intercept;
    private final ItemCurveFactory<SimpleRegressor, StandardCurveType> _factory;
    private final int _maxParamCount;
    private final List<SimpleRegressor> _regressors;
    private final SortedSet<SimpleRegressor> _curveRegressors;
    private final Set<SimpleRegressor> _nonCurveRegressors;

    public ItemClassifierSettings(ItemSettings settings_, String intercept_, SimpleStatus status_, int maxParamCount_, List<String> regressors_, Set<String> curveRegressors_) {
        this._settings = null == settings_ ? new ItemSettings() : settings_;
        EnumFamily regFamily = SimpleRegressor.generateFamily(regressors_);
        this._factory = new StandardCurveFactory();
        this._fromStatus = status_;
        this._intercept = (SimpleRegressor)regFamily.getFromName(intercept_);
        this._maxParamCount = maxParamCount_;
        this._regressors = Collections.unmodifiableList(new ArrayList(regFamily.getMembers()));
        TreeSet<EnumMember> curveSet = new TreeSet<EnumMember>();
        for (String next : curveRegressors_) {
            curveSet.add(regFamily.getFromName(next));
        }
        this._curveRegressors = Collections.unmodifiableSortedSet(curveSet);
        TreeSet<SimpleRegressor> nonCurveRegressors = new TreeSet<SimpleRegressor>();
        for (SimpleRegressor next : this._regressors) {
            if (this._curveRegressors.contains(next) || this._intercept == next) continue;
            nonCurveRegressors.add(next);
        }
        this._nonCurveRegressors = Collections.unmodifiableSortedSet(nonCurveRegressors);
        if (this._nonCurveRegressors.size() + this._curveRegressors.size() + 1 != this._regressors.size()) {
            throw new IllegalArgumentException("Regressor mismatch: Either regressors contains repeated items, or curveRegressors contains items not in regressors: " + this._nonCurveRegressors.toString() + " \n: " + this._curveRegressors.toString() + " \n: " + this._regressors.toString());
        }
    }

    public ItemSettings getSettings() {
        return this._settings;
    }

    public SimpleStatus getFromStatus() {
        return this._fromStatus;
    }

    public SimpleRegressor getIntercept() {
        return this._intercept;
    }

    public ItemCurveFactory<SimpleRegressor, StandardCurveType> getFactory() {
        return this._factory;
    }

    public int getMaxParamCount() {
        return this._maxParamCount;
    }

    public List<SimpleRegressor> getRegressors() {
        return this._regressors;
    }

    public SortedSet<SimpleRegressor> getCurveRegressors() {
        return this._curveRegressors;
    }

    public Set<SimpleRegressor> getNonCurveRegressors() {
        return this._nonCurveRegressors;
    }
}

