/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.tjw.item.spark;

import edu.columbia.tjw.item.ItemCurveFactory;
import edu.columbia.tjw.item.ItemSettings;
import edu.columbia.tjw.item.base.SimpleRegressor;
import edu.columbia.tjw.item.base.SimpleStatus;
import edu.columbia.tjw.item.base.StandardCurveFactory;
import edu.columbia.tjw.item.base.StandardCurveType;
import edu.columbia.tjw.item.util.EnumFamily;
import edu.columbia.tjw.item.util.EnumMember;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;

public final class ItemClassifierSettings
implements Serializable {
    private static final long serialVersionUID = -4137037306764905399L;
    public ItemSettings _settings;
    private final SimpleStatus _fromStatus;
    @Deprecated
    private final SimpleRegressor _intercept;
    private final ItemCurveFactory<SimpleRegressor, StandardCurveType> _factory;
    private final int _maxParamCount;
    private final List<SimpleRegressor> _regressors;
    private final SortedSet<SimpleRegressor> _curveRegressors;
    private final Set<SimpleRegressor> _nonCurveRegressors;
    private final EnumFamily<SimpleRegressor> _regFamily;

    public ItemClassifierSettings(ItemClassifierSettings base_, ItemSettings settings_) {
        this._settings = settings_;
        this._fromStatus = base_._fromStatus;
        this._intercept = base_._intercept;
        this._factory = base_._factory;
        this._maxParamCount = base_._maxParamCount;
        this._regressors = base_._regressors;
        this._curveRegressors = base_._curveRegressors;
        this._nonCurveRegressors = base_._nonCurveRegressors;
        this._regFamily = base_._regFamily == null ? base_._intercept.getFamily() : base_._regFamily;
    }

    public ItemClassifierSettings(ItemSettings settings_, SimpleStatus status_, int maxParamCount_, List<String> regressors_, Set<String> curveRegressors_) {
        this._settings = null == settings_ ? new ItemSettings() : settings_;
        this._regFamily = SimpleRegressor.generateFamily(regressors_);
        this._factory = new StandardCurveFactory();
        this._fromStatus = status_;
        this._intercept = null;
        this._maxParamCount = maxParamCount_;
        this._regressors = Collections.unmodifiableList(new ArrayList(this._regFamily.getMembers()));
        TreeSet<EnumMember> curveSet = new TreeSet<EnumMember>();
        for (String next : curveRegressors_) {
            curveSet.add(this._regFamily.getFromName(next));
        }
        this._curveRegressors = Collections.unmodifiableSortedSet(curveSet);
        TreeSet<SimpleRegressor> nonCurveRegressors = new TreeSet<SimpleRegressor>();
        for (SimpleRegressor next : this._regressors) {
            if (this._curveRegressors.contains(next) || this._intercept == next) continue;
            nonCurveRegressors.add(next);
        }
        this._nonCurveRegressors = Collections.unmodifiableSortedSet(nonCurveRegressors);
        if (this._nonCurveRegressors.size() + this._curveRegressors.size() != this._regressors.size()) {
            throw new IllegalArgumentException("Regressor mismatch: Either regressors contains repeated items, or curveRegressors contains items not in regressors: " + this._nonCurveRegressors.toString() + " \n: " + this._curveRegressors.toString() + " \n: " + this._regressors.toString());
        }
    }

    public ItemSettings getSettings() {
        return this._settings;
    }

    public SimpleStatus getFromStatus() {
        return this._fromStatus;
    }

    public EnumFamily<SimpleRegressor> getRegressorFamily() {
        return this._regFamily;
    }

    public ItemCurveFactory<SimpleRegressor, StandardCurveType> getFactory() {
        return this._factory;
    }

    public int getMaxParamCount() {
        return this._maxParamCount;
    }

    public List<SimpleRegressor> getRegressors() {
        return this._regressors;
    }

    public SortedSet<SimpleRegressor> getCurveRegressors() {
        return this._curveRegressors;
    }

    public Set<SimpleRegressor> getNonCurveRegressors() {
        return this._nonCurveRegressors;
    }

    public void save(String fileName_) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(fileName_);
             GZIPOutputStream zipOut = new GZIPOutputStream(fout);
             ObjectOutputStream oOut = new ObjectOutputStream(zipOut);){
            oOut.writeObject(this);
        }
    }

    /*
     * Exception decompiling
     */
    public static ItemClassifierSettings load(String filename_) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

