/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.ann.FeedForwardTrainer;
import org.apache.spark.ml.ann.IceFeedForwardTopology;
import org.apache.spark.ml.ann.IceFeedForwardTopology$;
import org.apache.spark.ml.ann.IcePerceptronClassificationModel;
import org.apache.spark.ml.ann.Topology;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.classification.IcePerceptronClassifier$;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u00015\u0011q#S2f!\u0016\u00148-\u001a9ue>t7\t\\1tg&4\u0017.\u001a:\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dqy\u0002#B\b\u0011%aIR\"\u0001\u0002\n\u0005E\u0011!a\u0006)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004mS:\fGnZ\u0005\u0003/Q\u0011aAV3di>\u0014\bCA\b\u0001!\ty!$\u0003\u0002\u001c\u0005\t9S*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tyQ$\u0003\u0002\u001f\u0005\tQR*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u0004\u0016M]1ngB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0005kRLG.\u0003\u0002%C\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011I\u0014\u0002\u0007ULG-F\u0001)!\tIsF\u0004\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018,Q\r)3'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0019\t!\"\u00198o_R\fG/[8o\u0013\tATGA\u0003TS:\u001cW-I\u0001;\u0003\u0015\td&\u000e\u00181\u0011!a\u0004A!A!\u0002\u0013A\u0013\u0001B;jI\u0002B3aO\u001a:\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u0019a\u0014N\\5u}Q\u0011\u0001$\u0011\u0005\u0006My\u0002\r\u0001\u000b\u0015\u0004\u0003NJ\u0004f\u0001 4s!9Q\t\u0001b\u0001\n\u000b1\u0015\u0001C5dKN\u001b\u0017\r\\3\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0003\u0002\u000bA\f'/Y7\n\u00051K%a\u0003#pk\ndW\rU1sC6DaA\u0014\u0001!\u0002\u001b9\u0015!C5dKN\u001b\u0017\r\\3!\u0011\u0015\u0001\u0006\u0001\"\u0001R\u00031\u0019X\r^%dK\u001a\u000b7\r^8s)\t\u00116+D\u0001\u0001\u0011\u0015!v\n1\u0001V\u0003\u00151\u0018\r\\;f!\tQc+\u0003\u0002XW\t1Ai\\;cY\u0016DQa\u0010\u0001\u0005\u0002e#\u0012\u0001\u0007\u0015\u00041NJ\u0004\"\u0002/\u0001\t\u0003i\u0016!C:fi2\u000b\u00170\u001a:t)\t\u0011f\fC\u0003U7\u0002\u0007q\fE\u0002+A\nL!!Y\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\u001a\u0017B\u00013,\u0005\rIe\u000e\u001e\u0015\u00047NJ\u0004\"B4\u0001\t\u0003A\u0017\u0001D:fi\ncwnY6TSj,GC\u0001*j\u0011\u0015!f\r1\u0001cQ\r17'\u000f\u0005\u0006Y\u0002!\t!\\\u0001\ng\u0016$8k\u001c7wKJ$\"A\u00158\t\u000bQ[\u0007\u0019\u0001\u0015)\u0007-\u001c\u0004/I\u0001r\u0003\u0015\u0011d\u0006\r\u00181\u0011\u0015\u0019\b\u0001\"\u0001u\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003%VDQ\u0001\u0016:A\u0002\tD3A]\u001a:\u0011\u0015A\b\u0001\"\u0001z\u0003\u0019\u0019X\r\u001e+pYR\u0011!K\u001f\u0005\u0006)^\u0004\r!\u0016\u0015\u0004oNJ\u0004\"B?\u0001\t\u0003q\u0018aB:fiN+W\r\u001a\u000b\u0003%~Da\u0001\u0016?A\u0002\u0005\u0005\u0001c\u0001\u0016\u0002\u0004%\u0019\u0011QA\u0016\u0003\t1{gn\u001a\u0015\u0004yNJ\u0004bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u0012g\u0016$\u0018J\\5uS\u0006dw+Z5hQR\u001cHc\u0001*\u0002\u0010!1A+!\u0003A\u0002IAC!!\u00034a\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011aC:fiN#X\r]*ju\u0016$2AUA\r\u0011\u0019!\u00161\u0003a\u0001+\"\"\u00111C\u001aq\u0011\u001d\ty\u0002\u0001C!\u0003C\tAaY8qsR\u0019\u0001$a\t\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\tQ!\u001a=ue\u0006\u00042\u0001SA\u0015\u0013\r\tY#\u0013\u0002\t!\u0006\u0014\u0018-\\'ba\"\"\u0011QD\u001a:\u0011\u001d\t\t\u0004\u0001C)\u0003g\tQ\u0001\u001e:bS:$B!!\u000e\u0002BA!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<\u0011\t1!\u00198o\u0013\u0011\ty$!\u000f\u0003A%\u001bW\rU3sG\u0016\u0004HO]8o\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0005\t\u0003\u0007\ny\u00031\u0001\u0002F\u00059A-\u0019;bg\u0016$\b\u0007BA$\u0003/\u0002b!!\u0013\u0002P\u0005MSBAA&\u0015\r\tiEB\u0001\u0004gFd\u0017\u0002BA)\u0003\u0017\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002V\u0005]C\u0002\u0001\u0003\r\u00033\n\t%!A\u0001\u0002\u000b\u0005\u00111\f\u0002\u0004?\u0012\n\u0014\u0003BA/\u0003G\u00022AKA0\u0013\r\t\tg\u000b\u0002\b\u001d>$\b.\u001b8h!\rQ\u0013QM\u0005\u0004\u0003OZ#aA!os\"\u001a\u0001aM\u001d\b\u000f\u00055$\u0001#\u0001\u0002p\u00059\u0012jY3QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aLWM\u001d\t\u0004\u001f\u0005EdAB\u0001\u0003\u0011\u0003\t\u0019h\u0005\u0005\u0002r\u0005U\u00141PAA!\rQ\u0013qO\u0005\u0004\u0003sZ#AB!osJ+g\r\u0005\u0003!\u0003{B\u0012bAA@C\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u0001\u0016\u0002\u0004&\u0019\u0011QQ\u0016\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f}\n\t\b\"\u0001\u0002\nR\u0011\u0011q\u000e\u0005\f\u0003\u001b\u000b\tH1A\u0005\u0002\t\ty)A\u0003M\u0005\u001a;5+\u0006\u0002\u0002\u0012B!\u00111SAO\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015\u0001\u00027b]\u001eT!!a'\u0002\t)\fg/Y\u0005\u0004a\u0005U\u0005\"CAQ\u0003c\u0002\u000b\u0011BAI\u0003\u0019a%IR$TA!Y\u0011QUA9\u0005\u0004%\tAAAH\u0003\t9E\tC\u0005\u0002*\u0006E\u0004\u0015!\u0003\u0002\u0012\u0006\u0019q\t\u0012\u0011\t\u0017\u00055\u0016\u0011\u000fb\u0001\n\u0003\u0011\u0011qV\u0001\u0011gV\u0004\bo\u001c:uK\u0012\u001cv\u000e\u001c<feN,\"!!-\u0011\t)\u0002\u0017\u0011\u0013\u0005\n\u0003k\u000b\t\b)A\u0005\u0003c\u000b\u0011c];qa>\u0014H/\u001a3T_24XM]:!\u0011!\tI,!\u001d\u0005B\u0005m\u0016\u0001\u00027pC\u0012$2\u0001GA_\u0011\u001d\ty,a.A\u0002!\nA\u0001]1uQ\"\"\u0011qW\u001aq\u0011)\t)-!\u001d\u0002\u0002\u0013%\u0011qY\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002JB!\u00111SAf\u0013\u0011\ti-!&\u0003\r=\u0013'.Z2uQ\u0011\t\th\r9)\t\u0005-4\u0007\u001d")
public class IcePerceptronClassifier
extends ProbabilisticClassifier<Vector, IcePerceptronClassifier, MultilayerPerceptronClassificationModel>
implements MultilayerPerceptronParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam iceScale;
    private final IntArrayParam layers;
    private final IntParam blockSize;
    private final Param<String> solver;
    private final Param<Vector> initialWeights;
    private final DoubleParam stepSize;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final LongParam seed;

    public static MLReader<IcePerceptronClassifier> read() {
        return IcePerceptronClassifier$.MODULE$.read();
    }

    public static IcePerceptronClassifier load(String string) {
        return IcePerceptronClassifier$.MODULE$.load(string);
    }

    public MLWriter write() {
        return DefaultParamsWritable.class.write((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public final IntArrayParam layers() {
        return this.layers;
    }

    public final IntParam blockSize() {
        return this.blockSize;
    }

    public final Param<String> solver() {
        return this.solver;
    }

    public final Param<Vector> initialWeights() {
        return this.initialWeights;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$layers_$eq(IntArrayParam x$1) {
        this.layers = x$1;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$initialWeights_$eq(Param x$1) {
        this.initialWeights = x$1;
    }

    public final int[] getLayers() {
        return MultilayerPerceptronParams.class.getLayers((MultilayerPerceptronParams)this);
    }

    public final int getBlockSize() {
        return MultilayerPerceptronParams.class.getBlockSize((MultilayerPerceptronParams)this);
    }

    public final Vector getInitialWeights() {
        return MultilayerPerceptronParams.class.getInitialWeights((MultilayerPerceptronParams)this);
    }

    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
    }

    public final String getSolver() {
        return HasSolver.class.getSolver((HasSolver)this);
    }

    public DoubleParam stepSize() {
        return this.stepSize;
    }

    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    public final double getStepSize() {
        return HasStepSize.class.getStepSize((HasStepSize)this);
    }

    public final DoubleParam tol() {
        return this.tol;
    }

    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    public final double getTol() {
        return HasTol.class.getTol((HasTol)this);
    }

    public final IntParam maxIter() {
        return this.maxIter;
    }

    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    public final int getMaxIter() {
        return HasMaxIter.class.getMaxIter((HasMaxIter)this);
    }

    public final LongParam seed() {
        return this.seed;
    }

    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    public final long getSeed() {
        return HasSeed.class.getSeed((HasSeed)this);
    }

    public String uid() {
        return this.uid;
    }

    public final DoubleParam iceScale() {
        return this.iceScale;
    }

    public IcePerceptronClassifier setIceFactor(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.iceScale(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier setLayers(int[] value) {
        return (IcePerceptronClassifier)this.set((Param)this.layers(), value);
    }

    public IcePerceptronClassifier setBlockSize(int value) {
        return (IcePerceptronClassifier)this.set((Param)this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public IcePerceptronClassifier setSolver(String value) {
        return (IcePerceptronClassifier)this.set(this.solver(), value);
    }

    public IcePerceptronClassifier setMaxIter(int value) {
        return (IcePerceptronClassifier)this.set((Param)this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public IcePerceptronClassifier setTol(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier setSeed(long value) {
        return (IcePerceptronClassifier)this.set((Param)this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public IcePerceptronClassifier setInitialWeights(Vector value) {
        return (IcePerceptronClassifier)this.set(this.initialWeights(), value);
    }

    public IcePerceptronClassifier setStepSize(double value) {
        return (IcePerceptronClassifier)this.set((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public IcePerceptronClassifier copy(ParamMap extra) {
        return (IcePerceptronClassifier)this.defaultCopy(extra);
    }

    public IcePerceptronClassificationModel train(Dataset<?> dataset) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            IcePerceptronClassificationModel icePerceptronClassificationModel;
            Object object = new Object();
            try {
                icePerceptronClassificationModel = (IcePerceptronClassificationModel)((Object)Instrumentation$.MODULE$.instrumented((Function1)new Serializable(this, dataset, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IcePerceptronClassifier $outer;
                    private final Dataset dataset$1;
                    private final Object nonLocalReturnKey1$1;

                    public final Nothing$ apply(Instrumentation instr) {
                        block4: {
                            FeedForwardTrainer trainer;
                            RDD data;
                            int[] myLayers;
                            block3: {
                                LBFGS lBFGS;
                                block2: {
                                    instr.logPipelineStage((PipelineStage)this.$outer);
                                    instr.logDataset(this.dataset$1);
                                    instr.logParams((Params)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.$outer.labelCol(), this.$outer.featuresCol(), this.$outer.predictionCol(), this.$outer.layers(), this.$outer.maxIter(), this.$outer.tol(), this.$outer.blockSize(), this.$outer.solver(), this.$outer.stepSize(), this.$outer.seed()}));
                                    double iceMult = BoxesRunTime.unboxToDouble((Object)this.$outer.get((Param)this.$outer.iceScale()).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final double apply() {
                                            return this.apply$mcD$sp();
                                        }

                                        public double apply$mcD$sp() {
                                            return 1.0;
                                        }
                                    }));
                                    myLayers = (int[])this.$outer.$((Param)this.$outer.layers());
                                    int labels = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(myLayers).last());
                                    instr.logNumClasses((long)labels);
                                    instr.logNumFeatures((long)BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(myLayers).head()));
                                    String encodedLabelCol = new StringBuilder().append((Object)"_encoded").append(this.$outer.$(this.$outer.labelCol())).toString();
                                    OneHotEncoderModel encodeModel = new OneHotEncoderModel(this.$outer.uid(), new int[]{labels}).setInputCols((String[])((Object[])new String[]{(String)this.$outer.$(this.$outer.labelCol())})).setOutputCols((String[])((Object[])new String[]{encodedLabelCol})).setDropLast(false);
                                    Dataset encodedDataset = encodeModel.transform(this.dataset$1);
                                    data = encodedDataset.select((String)this.$outer.$(this.$outer.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{encodedLabelCol})).rdd().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Tuple2<Vector, Vector> apply(Row x0$1) {
                                            Row row = x0$1;
                                            Some some = Row$.MODULE$.unapplySeq(row);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                Object features = ((SeqLike)some.get()).apply(0);
                                                Object encodedLabel = ((SeqLike)some.get()).apply(1);
                                                if (features instanceof Vector) {
                                                    Vector vector = (Vector)features;
                                                    if (encodedLabel instanceof Vector) {
                                                        Vector vector2 = (Vector)encodedLabel;
                                                        Tuple2 tuple2 = new Tuple2((Object)vector, (Object)vector2);
                                                        return tuple2;
                                                    }
                                                }
                                            }
                                            throw new MatchError((Object)row);
                                        }
                                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                                    IceFeedForwardTopology topology = IceFeedForwardTopology$.MODULE$.multiLayerPerceptron(myLayers, this.dataset$1.count(), iceMult);
                                    trainer = new FeedForwardTrainer((Topology)topology, myLayers[0], BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(myLayers).last()));
                                    FeedForwardTrainer feedForwardTrainer = this.$outer.isDefined(this.$outer.initialWeights()) ? trainer.setWeights((Vector)this.$outer.$(this.$outer.initialWeights())) : trainer.setSeed(BoxesRunTime.unboxToLong((Object)this.$outer.$((Param)this.$outer.seed())));
                                    Object object = this.$outer.$(this.$outer.solver());
                                    String string = IcePerceptronClassifier$.MODULE$.LBFGS();
                                    if (object != null ? !object.equals(string) : string != null) break block2;
                                    lBFGS = trainer.LBFGSOptimizer().setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.tol()))).setNumIterations(BoxesRunTime.unboxToInt((Object)this.$outer.$((Param)this.$outer.maxIter())));
                                    break block3;
                                }
                                Object object = this.$outer.$(this.$outer.solver());
                                String string = IcePerceptronClassifier$.MODULE$.GD();
                                if (object != null ? !object.equals(string) : string != null) break block4;
                                lBFGS = trainer.SGDOptimizer().setNumIterations(BoxesRunTime.unboxToInt((Object)this.$outer.$((Param)this.$outer.maxIter()))).setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.tol()))).setStepSize(BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.stepSize())));
                            }
                            trainer.setStackSize(BoxesRunTime.unboxToInt((Object)this.$outer.$((Param)this.$outer.blockSize())));
                            TopologyModel mlpModel = trainer.train(data);
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)((Object)new IcePerceptronClassificationModel(this.$outer.uid(), myLayers, mlpModel.weights(), BoxesRunTime.unboxToInt((Object)this.$outer.$((Param)this.$outer.blockSize())))));
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The solver ", " is not supported by MultilayerPerceptronClassifier."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.solver()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dataset$1 = dataset$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                icePerceptronClassificationModel = (IcePerceptronClassificationModel)((Object)nonLocalReturnControl2.value());
            }
            return icePerceptronClassificationModel;
        }
        throw nonLocalReturnControl2;
    }

    public IcePerceptronClassifier(String uid) {
        this.uid = uid;
        HasSeed.class.$init$((HasSeed)this);
        HasMaxIter.class.$init$((HasMaxIter)this);
        HasTol.class.$init$((HasTol)this);
        HasStepSize.class.$init$((HasStepSize)this);
        HasSolver.class.$init$((HasSolver)this);
        MultilayerPerceptronParams.class.$init$((MultilayerPerceptronParams)this);
        MLWritable.class.$init$((MLWritable)this);
        DefaultParamsWritable.class.$init$((DefaultParamsWritable)this);
        this.iceScale = new DoubleParam((Identifiable)this, "iceScale", "Ice effect scale, in [0, 1] where 0 is MLE and 1.0 is full ICE.", ParamValidators$.MODULE$.inRange(0.0, 1.0));
    }

    public IcePerceptronClassifier() {
        this(Identifiable$.MODULE$.randomUID("mlpc"));
    }
}

